/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.lang;

import com.hp.hpl.jena.graph.Node;
import org.openjena.atlas.AtlasException;
import org.openjena.atlas.event.Event;
import org.openjena.atlas.event.EventManager;
import org.openjena.atlas.iterator.PeekIterator;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.ErrorHandler;
import org.openjena.riot.ParserProfile;
import org.openjena.riot.RiotParseException;
import org.openjena.riot.SysRIOT;
import org.openjena.riot.lang.LangRIOT;
import org.openjena.riot.tokens.Token;
import org.openjena.riot.tokens.TokenType;
import org.openjena.riot.tokens.Tokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LangBase<X>
implements LangRIOT {
    protected ParserProfile profile;
    protected final Tokenizer tokens;
    private final PeekIterator<Token> peekIter;
    protected final Sink<X> sink;
    private Token tokenEOF = null;
    protected long currLine = -1L;
    protected long currCol = -1L;

    protected LangBase(Tokenizer tokens, Sink<X> sink, ParserProfile profile) {
        this.setProfile(profile);
        this.sink = sink;
        this.tokens = tokens;
        this.peekIter = new PeekIterator<Token>(tokens);
    }

    @Override
    public ParserProfile getProfile() {
        return this.profile;
    }

    @Override
    public void setProfile(ParserProfile profile) {
        this.profile = profile;
    }

    @Override
    public void parse() {
        EventManager.send(this.sink, new Event(SysRIOT.startRead, null));
        this.runParser();
        this.sink.flush();
        EventManager.send(this.sink, new Event(SysRIOT.finishRead, null));
        this.tokens.close();
    }

    protected abstract void runParser();

    protected final Token peekToken() {
        if (this.eof()) {
            return this.tokenEOF;
        }
        return this.peekIter.peek();
    }

    protected final boolean eof() {
        if (this.tokenEOF != null) {
            return true;
        }
        if (!this.moreTokens()) {
            this.tokenEOF = new Token(this.tokens.getLine(), this.tokens.getColumn());
            this.tokenEOF.setType(TokenType.EOF);
            return true;
        }
        return false;
    }

    protected final boolean moreTokens() {
        return this.peekIter.hasNext();
    }

    protected final boolean lookingAt(TokenType tokenType) {
        if (this.eof()) {
            return tokenType == TokenType.EOF;
        }
        if (tokenType == TokenType.NODE) {
            return this.peekToken().isNode();
        }
        return this.peekToken().hasType(tokenType);
    }

    protected final Token nextToken() {
        if (this.eof()) {
            return this.tokenEOF;
        }
        try {
            Token t = this.peekIter.next();
            this.currLine = t.getLine();
            this.currCol = t.getColumn();
            return t;
        }
        catch (RiotParseException ex) {
            this.raiseException(ex);
            throw ex;
        }
        catch (AtlasException ex) {
            RiotParseException ex2 = new RiotParseException(ex.getMessage(), -1L, -1L);
            this.raiseException(ex2);
            throw ex2;
        }
    }

    protected final Node scopedBNode(Node scopeNode, String label) {
        return this.profile.getLabelToNode().get(scopeNode, label);
    }

    protected final void expectOrEOF(String msg, TokenType tokenType) {
        if (this.eof()) {
            return;
        }
        this.expect(msg, tokenType);
    }

    protected final void expect(String msg, TokenType ttype) {
        if (!this.lookingAt(ttype)) {
            Token location = this.peekToken();
            this.exception(location, msg, new Object[0]);
        }
        this.nextToken();
    }

    protected final void exception(Token token, String msg, Object ... args) {
        if (token != null) {
            this.exceptionDirect(String.format(msg, args), token.getLine(), token.getColumn());
        } else {
            this.exceptionDirect(String.format(msg, args), -1L, -1L);
        }
    }

    protected final void exceptionDirect(String msg, long line, long col) {
        this.raiseException(new RiotParseException(msg, line, col));
    }

    protected final void raiseException(RiotParseException ex) {
        ErrorHandler errorHandler = this.profile.getHandler();
        if (errorHandler != null) {
            errorHandler.fatal(ex.getOriginalMessage(), ex.getLine(), ex.getCol());
        }
        throw ex;
    }
}

