/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.inf;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openjena.atlas.lib.Sink;
import org.openjena.atlas.lib.StrUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InferenceExpanderRDFS
implements Sink<Triple> {
    private final Sink<Triple> output;
    private final Map<Node, List<Node>> transClasses;
    private final Map<Node, List<Node>> transProperties;
    private final Map<Node, List<Node>> domainList;
    private final Map<Node, List<Node>> rangeList;
    static final Node rdfType = RDF.type.asNode();

    public InferenceExpanderRDFS(Sink<Triple> output, Model vocab) {
        this.output = output;
        this.transClasses = new HashMap<Node, List<Node>>();
        this.transProperties = new HashMap<Node, List<Node>>();
        this.domainList = new HashMap<Node, List<Node>>();
        this.rangeList = new HashMap<Node, List<Node>>();
        InferenceExpanderRDFS.exec("SELECT ?x ?y { ?x rdfs:subClassOf+ ?y }", vocab, this.transClasses);
        InferenceExpanderRDFS.exec("SELECT ?x ?y { ?x rdfs:subPropertyOf+ ?y }", vocab, this.transProperties);
        InferenceExpanderRDFS.exec("SELECT ?x ?y { ?x rdfs:domain ?y }", vocab, this.domainList);
        InferenceExpanderRDFS.exec("SELECT ?x ?y { ?x rdfs:range ?y }", vocab, this.rangeList);
    }

    private static void exec(String qs, Model model, Map<Node, List<Node>> multimap) {
        String preamble = StrUtils.strjoinNL("PREFIX  rdf:    <http://www.w3.org/1999/02/22-rdf-syntax-ns#>", "PREFIX  rdfs:   <http://www.w3.org/2000/01/rdf-schema#>", "PREFIX  xsd:    <http://www.w3.org/2001/XMLSchema#>", "PREFIX  owl:    <http://www.w3.org/2002/07/owl#>", "PREFIX skos:    <http://www.w3.org/2004/02/skos/core#>");
        Query query2 = QueryFactory.create(preamble + "\n" + qs, Syntax.syntaxARQ);
        QueryExecution qexec = QueryExecutionFactory.create(query2, model);
        ResultSet rs = qexec.execSelect();
        while (rs.hasNext()) {
            QuerySolution soln = rs.next();
            Node x = soln.get("x").asNode();
            Node y = soln.get("y").asNode();
            if (!multimap.containsKey(x)) {
                multimap.put(x, new ArrayList());
            }
            multimap.get(x).add(y);
        }
    }

    @Override
    public void send(Triple triple) {
        this.output.send(triple);
        Node s = triple.getSubject();
        Node p = triple.getPredicate();
        Node o = triple.getObject();
        this.subClass(s, p, o);
        this.subProperty(s, p, o);
        this.domain(s, p, o);
        this.range(s, p, o);
    }

    private final void subClass(Node s, Node p, Node o) {
        List<Node> x;
        if (p.equals((Object)rdfType) && (x = this.transClasses.get(o)) != null) {
            for (Node c : x) {
                this.output.send(new Triple(s, p, c));
            }
        }
    }

    private void subProperty(Node s, Node p, Node o) {
        List<Node> x = this.transProperties.get(p);
        if (x != null) {
            for (Node p2 : x) {
                this.output.send(new Triple(s, p2, o));
            }
        }
    }

    private final void domain(Node s, Node p, Node o) {
        List<Node> x = this.domainList.get(p);
        if (x != null) {
            for (Node c : x) {
                this.output.send(new Triple(s, rdfType, c));
                this.subClass(s, rdfType, c);
            }
        }
    }

    private final void range(Node s, Node p, Node o) {
        if (o.isLiteral()) {
            return;
        }
        List<Node> x = this.rangeList.get(p);
        if (x != null) {
            for (Node c : x) {
                this.output.send(new Triple(o, rdfType, c));
                this.subClass(o, rdfType, c);
            }
        }
    }

    @Override
    public void flush() {
        this.output.flush();
    }

    @Override
    public void close() {
        this.output.close();
    }
}

