/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.Quad;
import java.io.InputStream;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.ErrorHandler;
import org.openjena.riot.ErrorHandlerLib;
import org.openjena.riot.IRIResolver;
import org.openjena.riot.Lang;
import org.openjena.riot.ParserProfile;
import org.openjena.riot.ParserProfileBase;
import org.openjena.riot.ParserProfileChecker;
import org.openjena.riot.PrefixMap;
import org.openjena.riot.Prologue;
import org.openjena.riot.RiotException;
import org.openjena.riot.SinkExtendTriplesToQuads;
import org.openjena.riot.lang.LangNQuads;
import org.openjena.riot.lang.LangNTriples;
import org.openjena.riot.lang.LangRDFXML;
import org.openjena.riot.lang.LangRIOT;
import org.openjena.riot.lang.LangTriG;
import org.openjena.riot.lang.LangTurtle;
import org.openjena.riot.tokens.Tokenizer;
import org.openjena.riot.tokens.TokenizerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RiotReader {
    public static ParserProfile profile(Lang lang, String baseIRI) {
        return RiotReader.profile(lang, baseIRI, ErrorHandlerLib.errorHandlerStd);
    }

    public static ParserProfile profile(Lang lang, String baseIRI, ErrorHandler handler) {
        switch (lang) {
            case NQUADS: 
            case NTRIPLES: {
                return RiotReader.profile(baseIRI, false, false, handler);
            }
            case N3: 
            case TURTLE: 
            case TRIG: 
            case RDFXML: {
                return RiotReader.profile(baseIRI, true, true, handler);
            }
        }
        return null;
    }

    public static ParserProfile profile(String baseIRI, boolean resolveIRIs, boolean checking, ErrorHandler handler) {
        Prologue prologue = resolveIRIs ? new Prologue(new PrefixMap(), IRIResolver.create(baseIRI)) : new Prologue(null, IRIResolver.createNoResolve());
        if (checking) {
            return new ParserProfileChecker(prologue, handler);
        }
        return new ParserProfileBase(prologue, handler);
    }

    public static void parseTriples(String filename, Sink<Triple> sink) {
        RiotReader.parseTriples(filename, null, null, sink);
    }

    public static void parseTriples(String filename, Lang lang, String baseIRI, Sink<Triple> sink) {
        RiotReader.checkTriplesLanguage(filename, lang);
        String printName = RiotReader.nameForFile(filename);
        InputStream in = IO.openFile(filename);
        String base = RiotReader.chooseBaseIRI(baseIRI, filename);
        if (lang == null) {
            lang = Lang.guess(filename, Lang.NTRIPLES);
        }
        if (lang == Lang.RDFXML) {
            LangRDFXML.create(in, base, filename, ErrorHandlerLib.errorHandlerStd, sink).parse();
            IO.close(in);
            return;
        }
        RiotReader.parseTriples(in, lang, base, sink);
        IO.close(in);
    }

    public static void parseTriples(InputStream in, Lang lang, String baseIRI, Sink<Triple> sink) {
        LangRIOT parser = RiotReader.createParserTriples(in, lang, baseIRI, sink);
        parser.parse();
    }

    public static void parseQuads(String filename, Sink<Quad> sink) {
        RiotReader.parseQuads(filename, null, null, sink);
    }

    public static void parseQuads(String filename, Lang lang, String baseIRI, Sink<Quad> sink) {
        String printName = RiotReader.nameForFile(filename);
        InputStream in = IO.openFile(filename);
        String base = RiotReader.chooseBaseIRI(baseIRI, filename);
        if (lang == null) {
            lang = Lang.guess(filename, Lang.NQUADS);
        }
        RiotReader.parseQuads(in, lang, base, sink);
        IO.close(in);
    }

    public static void parseQuads(InputStream in, Lang lang, String baseIRI, Sink<Quad> sink) {
        LangRIOT parser = RiotReader.createParserQuads(in, lang, baseIRI, sink);
        parser.parse();
    }

    public static LangRIOT createParserTriples(InputStream input, Lang lang, String baseIRI, Sink<Triple> sink) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizer(input);
        return RiotReader.createParserTriples(tokenizer, lang, baseIRI, sink);
    }

    public static LangRIOT createParserTriples(Tokenizer tokenizer, Lang lang, String baseIRI, Sink<Triple> sink) {
        switch (lang) {
            case N3: 
            case TURTLE: {
                return RiotReader.createParserTurtle(tokenizer, baseIRI, sink);
            }
            case NTRIPLES: {
                return RiotReader.createParserNTriples(tokenizer, sink);
            }
            case RDFXML: {
                throw new RiotException("Not linked in yet: " + (Object)((Object)lang));
            }
            case NQUADS: 
            case TRIG: {
                throw new RiotException("Not a triples language: " + (Object)((Object)lang));
            }
        }
        return null;
    }

    public static LangRIOT createParserQuads(InputStream input, Lang lang, String baseIRI, Sink<Quad> sink) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizer(input);
        return RiotReader.createParserQuads(tokenizer, lang, baseIRI, sink);
    }

    public static LangRIOT createParserQuads(Tokenizer tokenizer, Lang lang, String baseIRI, Sink<Quad> sink) {
        switch (lang) {
            case NTRIPLES: 
            case N3: 
            case TURTLE: 
            case RDFXML: {
                SinkExtendTriplesToQuads converter = new SinkExtendTriplesToQuads(sink);
                return RiotReader.createParserTriples(tokenizer, lang, baseIRI, (Sink<Triple>)converter);
            }
            case NQUADS: {
                return RiotReader.createParserNQuads(tokenizer, sink);
            }
            case TRIG: {
                return RiotReader.createParserTriG(tokenizer, baseIRI, sink);
            }
        }
        return null;
    }

    public static LangTurtle createParserTurtle(InputStream input, String baseIRI, Sink<Triple> sink) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizer(input);
        return RiotReader.createParserTurtle(tokenizer, baseIRI, sink);
    }

    public static LangTurtle createParserTurtle(Tokenizer tokenizer, String baseIRI, Sink<Triple> sink) {
        LangTurtle parser = new LangTurtle(baseIRI, tokenizer, RiotReader.profile(Lang.TURTLE, baseIRI), sink);
        return parser;
    }

    public static LangTriG createParserTriG(InputStream input, String baseIRI, Sink<Quad> sink) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizer(input);
        return RiotReader.createParserTriG(tokenizer, baseIRI, sink);
    }

    public static LangTriG createParserTriG(Tokenizer tokenizer, String baseIRI, Sink<Quad> sink) {
        if (baseIRI == null) {
            baseIRI = IRIResolver.chooseBaseURI().toString();
        }
        LangTriG parser = new LangTriG(baseIRI, tokenizer, RiotReader.profile(Lang.TRIG, baseIRI), sink);
        return parser;
    }

    public static LangNTriples createParserNTriples(InputStream input, Sink<Triple> sink) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizer(input);
        return RiotReader.createParserNTriples(tokenizer, sink);
    }

    public static LangNTriples createParserNTriples(Tokenizer tokenizer, Sink<Triple> sink) {
        LangNTriples parser = new LangNTriples(tokenizer, RiotReader.profile(Lang.NTRIPLES, null), sink);
        return parser;
    }

    public static LangNQuads createParserNQuads(InputStream input, Sink<Quad> sink) {
        Tokenizer tokenizer = TokenizerFactory.makeTokenizer(input);
        return RiotReader.createParserNQuads(tokenizer, sink);
    }

    public static LangNQuads createParserNQuads(Tokenizer tokenizer, Sink<Quad> sink) {
        LangNQuads parser = new LangNQuads(tokenizer, RiotReader.profile(Lang.NQUADS, null), sink);
        return parser;
    }

    private static String chooseBaseIRI(String baseIRI, String filename) {
        if (baseIRI != null) {
            return baseIRI;
        }
        if (filename == null || filename.equals("-")) {
            return "http://localhost/stdin/";
        }
        return IRIResolver.resolveGlobalToString(filename);
    }

    private static String nameForFile(String filename) {
        if (filename == null || filename.equals("-")) {
            return "stdin";
        }
        return filename;
    }

    private static void checkTriplesLanguage(String filename, Lang lang) {
        if (lang != null) {
            if (!lang.isTriples()) {
                throw new RiotException("Can only parse triples languages to a triples sink: " + lang.getName());
            }
            return;
        }
        lang = Lang.guess(filename);
        if (lang != null && !lang.isTriples()) {
            throw new RiotException("Can only parse triples languages to a triples sink: " + lang.getName());
        }
    }
}

