/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot;

import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.iri.IRIFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openjena.atlas.lib.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefixMap {
    private final Map<String, IRI> prefixes = new HashMap<String, IRI>();
    private final Map<String, IRI> prefixes2 = Collections.unmodifiableMap(this.prefixes);

    public PrefixMap() {
    }

    public PrefixMap(PrefixMap other) {
        this.prefixes.putAll(other.prefixes);
    }

    public Map<String, IRI> getMapping() {
        return this.prefixes2;
    }

    public void add(String prefix, String iriString) {
        prefix = PrefixMap.canonicalPrefix(prefix);
        IRI iri = IRIFactory.iriImplementation().create(iriString);
        this.prefixes.put(prefix, iri);
    }

    public void add(String prefix, IRI iri) {
        prefix = PrefixMap.canonicalPrefix(prefix);
        this.prefixes.put(prefix, iri);
    }

    public void delete(String prefix) {
        prefix = PrefixMap.canonicalPrefix(prefix);
        this.prefixes.remove(prefix);
    }

    public boolean contains(String prefix) {
        prefix = PrefixMap.canonicalPrefix(prefix);
        return this._contains(prefix);
    }

    protected boolean _contains(String prefix) {
        return this.prefixes.containsKey(prefix);
    }

    public String abbreviate(String uriStr) {
        for (Map.Entry<String, IRI> e2 : this.prefixes.entrySet()) {
            String prefix = e2.getValue().toString();
            if (!uriStr.startsWith(prefix)) continue;
            return e2.getKey() + ":" + uriStr.substring(prefix.length());
        }
        return null;
    }

    public Pair<String, String> abbrev(String uriStr) {
        for (Map.Entry<String, IRI> e2 : this.prefixes.entrySet()) {
            String prefix = e2.getValue().toString();
            if (!uriStr.startsWith(prefix)) continue;
            return new Pair<String, String>(e2.getKey(), uriStr.substring(prefix.length()));
        }
        return null;
    }

    public String expand(String prefix, String localName) {
        IRI x = this.prefixes.get(prefix = PrefixMap.canonicalPrefix(prefix));
        if (x == null) {
            return null;
        }
        return x.toString() + localName;
    }

    protected static String canonicalPrefix(String prefix) {
        if (prefix.endsWith(":")) {
            return prefix.substring(0, prefix.length() - 1);
        }
        return prefix;
    }
}

