/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.sparql.core.Quad;
import org.openjena.riot.ErrorHandler;
import org.openjena.riot.ParserProfile;
import org.openjena.riot.Prologue;
import org.openjena.riot.RiotException;
import org.openjena.riot.lang.LabelToNode;
import org.openjena.riot.tokens.Token;

public class ParserProfileBase
implements ParserProfile {
    protected ErrorHandler errorHandler;
    protected final Prologue prologue;
    protected final LabelToNode labelMapping;

    public ParserProfileBase(Prologue prologue, ErrorHandler errorHandler) {
        this.prologue = prologue;
        this.errorHandler = errorHandler;
        this.labelMapping = LabelToNode.createScopeByDocument();
    }

    public ErrorHandler getHandler() {
        return this.errorHandler;
    }

    public void setHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public Prologue getPrologue() {
        return this.prologue;
    }

    public LabelToNode getLabelToNode() {
        return this.labelMapping;
    }

    public String resolveIRI(String uriStr, long line, long col) {
        return this.makeIRI(uriStr, line, col).toString();
    }

    public IRI makeIRI(String uriStr, long line, long col) {
        IRI iri = this.prologue.getResolver().resolve(uriStr);
        return iri;
    }

    public Quad createQuad(Node g, Node s, Node p, Node o, long line, long col) {
        return new Quad(g, s, p, o);
    }

    public Triple createTriple(Node s, Node p, Node o, long line, long col) {
        return new Triple(s, p, o);
    }

    public Node createURI(String uriStr, long line, long col) {
        return Node.createURI((String)uriStr);
    }

    public Node createBlankNode(Node scope, String label, long line, long col) {
        return this.labelMapping.get(scope, label);
    }

    public Node createTypedLiteral(String lexical, RDFDatatype dt, long line, long col) {
        return Node.createLiteral((String)lexical, null, (RDFDatatype)dt);
    }

    public Node createLangLiteral(String lexical, String langTag, long line, long col) {
        return Node.createLiteral((String)lexical, (String)langTag, null);
    }

    public Node createPlainLiteral(String lexical, long line, long col) {
        return Node.createLiteral((String)lexical);
    }

    public Node create(Node currentGraph, Token token) {
        long line = token.getLine();
        long col = token.getColumn();
        String str2 = token.getImage();
        switch (token.getType()) {
            case BNODE: {
                return this.createBlankNode(currentGraph, str2, line, col);
            }
            case IRI: {
                return this.createURI(str2, line, col);
            }
            case PREFIXED_NAME: {
                String prefix = str2;
                String suffix = token.getImage2();
                String expansion = this.expandPrefixedName(prefix, suffix, token);
                return this.createURI(expansion, line, col);
            }
            case DECIMAL: {
                return this.createTypedLiteral(str2, (RDFDatatype)XSDDatatype.XSDdecimal, line, col);
            }
            case DOUBLE: {
                return this.createTypedLiteral(str2, (RDFDatatype)XSDDatatype.XSDdouble, line, col);
            }
            case INTEGER: {
                return this.createTypedLiteral(str2, (RDFDatatype)XSDDatatype.XSDinteger, line, col);
            }
            case LITERAL_DT: {
                String uriStr;
                Token tokenDT = token.getSubToken();
                switch (tokenDT.getType()) {
                    case IRI: {
                        uriStr = tokenDT.getImage();
                        break;
                    }
                    case PREFIXED_NAME: {
                        String prefix = tokenDT.getImage();
                        String suffix = tokenDT.getImage2();
                        uriStr = this.expandPrefixedName(prefix, suffix, tokenDT);
                        break;
                    }
                    default: {
                        throw new RiotException("Expected IRI for datatype: " + token);
                    }
                }
                uriStr = this.resolveIRI(uriStr, tokenDT.getLine(), tokenDT.getColumn());
                RDFDatatype dt = Node.getType((String)uriStr);
                return this.createTypedLiteral(str2, dt, line, col);
            }
            case LITERAL_LANG: {
                return this.createLangLiteral(str2, token.getImage2(), line, col);
            }
            case STRING: 
            case STRING1: 
            case STRING2: 
            case LONG_STRING1: 
            case LONG_STRING2: {
                return this.createPlainLiteral(str2, line, col);
            }
        }
        this.errorHandler.fatal("Not a valid token for an RDF term", line, col);
        return null;
    }

    private String expandPrefixedName(String prefix, String localPart, Token token) {
        String expansion = this.prologue.getPrefixMap().expand(prefix, localPart);
        if (expansion == null) {
            this.errorHandler.fatal("Undefined prefix: " + prefix, token.getLine(), token.getColumn());
        }
        return expansion;
    }
}

