/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot;

import org.openjena.riot.ErrorHandler;
import org.openjena.riot.RiotException;
import org.openjena.riot.SysRIOT;
import org.slf4j.Logger;

public class ErrorHandlerLib {
    public static final Logger stdLogger = SysRIOT.getLogger();
    public static final Logger noLogger = null;
    public static ErrorHandler errorHandlerStd = new ErrorHandlerStd(stdLogger);
    public static ErrorHandler errorHandlerStrict = new ErrorHandlerStrict(stdLogger);
    public static ErrorHandler errorHandlerWarn = new ErrorHandlerWarning(stdLogger);
    public static ErrorHandler errorHandlerNoLogging = new ErrorHandlerSimple();

    public static void setTestLogging(boolean visible) {
        errorHandlerStd = visible ? new ErrorHandlerStd(stdLogger) : new ErrorHandlerSimple();
    }

    private static class ErrorHandlerWarning
    extends ErrorLogger
    implements ErrorHandler {
        public ErrorHandlerWarning(Logger log) {
            super(log);
        }

        public void warning(String message, long line, long col) {
            this.logWarning(message, line, col);
        }

        public void error(String message, long line, long col) {
            this.logError(message, line, col);
        }

        public void fatal(String message, long line, long col) {
            this.logFatal(message, line, col);
            throw new RiotException(SysRIOT.fmtMessage(message, line, col));
        }
    }

    private static class ErrorHandlerStrict
    extends ErrorLogger
    implements ErrorHandler {
        public ErrorHandlerStrict(Logger log) {
            super(log);
        }

        public void warning(String message, long line, long col) {
            this.logWarning(message, line, col);
            throw new RiotException(SysRIOT.fmtMessage(message, line, col));
        }

        public void error(String message, long line, long col) {
            this.logError(message, line, col);
            throw new RiotException(SysRIOT.fmtMessage(message, line, col));
        }

        public void fatal(String message, long line, long col) {
            this.logFatal(message, line, col);
            throw new RiotException(SysRIOT.fmtMessage(message, line, col));
        }
    }

    private static class ErrorHandlerStd
    extends ErrorLogger
    implements ErrorHandler {
        public ErrorHandlerStd(Logger log) {
            super(log);
        }

        public void warning(String message, long line, long col) {
            this.logWarning(message, line, col);
        }

        public void error(String message, long line, long col) {
            this.logError(message, line, col);
            throw new RiotException(SysRIOT.fmtMessage(message, line, col));
        }

        public void fatal(String message, long line, long col) {
            this.logFatal(message, line, col);
            throw new RiotException(SysRIOT.fmtMessage(message, line, col));
        }
    }

    private static class ErrorHandlerSimple
    implements ErrorHandler {
        private ErrorHandlerSimple() {
        }

        public void warning(String message, long line, long col) {
        }

        public void error(String message, long line, long col) {
            throw new RiotException(SysRIOT.fmtMessage(message, line, col));
        }

        public void fatal(String message, long line, long col) {
            throw new RiotException(SysRIOT.fmtMessage(message, line, col));
        }
    }

    private static class ErrorLogger {
        protected final Logger log;

        public ErrorLogger(Logger log) {
            this.log = log;
        }

        public void logWarning(String message, long line, long col) {
            this.log.warn(SysRIOT.fmtMessage(message, line, col));
        }

        public void logError(String message, long line, long col) {
            this.log.error(SysRIOT.fmtMessage(message, line, col));
        }

        public void logFatal(String message, long line, long col) {
            this.logError(message, line, col);
        }
    }
}

