/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.lib;

import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.util.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.openjena.atlas.AtlasException;

public class PropertyUtils {
    public static Properties loadFromFile(String filename) throws IOException {
        Properties properties = new Properties();
        PropertyUtils.loadFromFile(properties, filename);
        return properties;
    }

    public static void loadFromFile(Properties properties, String filename) throws IOException {
        String x = FileUtils.readWholeFileAsUTF8((String)filename);
        byte[] b = x.getBytes("utf-8");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(b);
        properties.load(inputStream);
    }

    public static void storeToFile(Properties properties, String comment, String filename) throws IOException {
        String str2 = comment;
        if (str2 == null) {
            str2 = filename;
        }
        FileOutputStream fos = new FileOutputStream(filename);
        properties.store(fos, str2);
        fos.close();
    }

    public static int getPropertyAsInteger(Properties properties, String key) {
        String x = properties.getProperty(key);
        if (x == null) {
            throw new AtlasException("No such property key: " + key);
        }
        return Integer.parseInt(x);
    }

    public static int getPropertyAsInteger(Properties properties, String key, int defaultValue) {
        String x = properties.getProperty(key);
        if (x == null) {
            return defaultValue;
        }
        return Integer.parseInt(x);
    }

    public static boolean getPropertyAsBoolean(Properties properties, String key, boolean dftValue) {
        String x = properties.getProperty(key);
        if (x == null) {
            return dftValue;
        }
        if (x.equalsIgnoreCase("true")) {
            return true;
        }
        if (x.equalsIgnoreCase("false")) {
            return true;
        }
        throw new AtlasException("Value '" + x + "'not recognized for " + key);
    }

    public static Boolean getPropertyAsBoolean(Properties properties, String key) {
        String x = properties.getProperty(key);
        if (x == null) {
            throw new AtlasException("No such property key: " + key);
        }
        if (x.equalsIgnoreCase("true")) {
            return true;
        }
        if (x.equalsIgnoreCase("false")) {
            return true;
        }
        throw new AtlasException("Value '" + x + "'not recognized for " + key);
    }

    public boolean propertyEquals(Properties properties, String key, String value) {
        return Utils.equal(properties.getProperty(key), value);
    }

    public void ensurePropertySet(Properties properties, String key, String expected) {
        this.getOrSetDefault(properties, key, expected);
    }

    public String getOrSetDefault(Properties properties, String key, String expected) {
        String x = properties.getProperty(key);
        if (x == null) {
            properties.setProperty(key, expected);
            x = expected;
        }
        return x;
    }

    public void checkOrSetProperty(Properties properties, String key, String expected) {
        String x = properties.getProperty(key);
        if (x == null) {
            properties.setProperty(key, expected);
            return;
        }
        if (x.equals(expected)) {
            return;
        }
        this.inconsistent(properties, key, x, expected);
    }

    public void checkMetadata(Properties properties, String key, String expected) {
        String value = properties.getProperty(key);
        if (!Utils.equal(value, value)) {
            this.inconsistent(properties, key, value, expected);
        }
    }

    private void inconsistent(Properties properties, String key, String actual, String expected) {
        String msg = String.format("Inconsistent: key=%s value=%s expected=%s", key, actual == null ? "<null>" : actual, expected == null ? "<null>" : expected);
        throw new AtlasException(msg);
    }
}

