/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.lib;

import java.util.ArrayList;
import java.util.List;
import org.openjena.atlas.iterator.FilterUnique;
import org.openjena.atlas.iterator.Iter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListUtils {
    private ListUtils() {
    }

    public static <T> List<T> unique(List<T> list) {
        Iter iter = Iter.iter(list.iterator());
        return iter.filter(new FilterUnique()).toList();
    }

    public static List<Integer> asList(int ... values) {
        ArrayList<Integer> x = new ArrayList<Integer>();
        for (int v : values) {
            x.add(v);
        }
        return x;
    }

    public static <T> String str(T[] array) {
        StringBuilder buff = new StringBuilder();
        String sep = "[";
        for (int i = 0; i < array.length; ++i) {
            buff.append(sep);
            sep = ", ";
            buff.append(array[i]);
        }
        buff.append("]");
        return buff.toString();
    }

    public static String str(int[] array) {
        StringBuilder buff = new StringBuilder();
        String sep = "[";
        for (int i = 0; i < array.length; ++i) {
            buff.append(sep);
            sep = ", ";
            buff.append(array[i]);
        }
        buff.append("]");
        return buff.toString();
    }

    public static String str(long[] array) {
        StringBuilder buff = new StringBuilder();
        String sep = "[";
        for (int i = 0; i < array.length; ++i) {
            buff.append(sep);
            sep = ", ";
            buff.append(array[i]);
        }
        buff.append("]");
        return buff.toString();
    }
}

