/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.json.io.parserjavacc;

import com.hp.hpl.jena.n3.turtle.parser.TokenMgrError;
import java.io.Reader;
import org.openjena.atlas.json.JsonParseException;
import org.openjena.atlas.json.io.JSONHandler;
import org.openjena.atlas.json.io.parserjavacc.JSONPrinter;
import org.openjena.atlas.json.io.parserjavacc.javacc.JSON_Parser;
import org.openjena.atlas.json.io.parserjavacc.javacc.ParseException;

public class JSONParserJavaCC {
    public static void parse(Reader reader) {
        JSONParserJavaCC.parse(reader, new JSONPrinter());
    }

    public static void parse(Reader reader, JSONHandler handler) {
        JSON_Parser p = new JSON_Parser(reader);
        p.setHandler(handler);
        try {
            p.unit();
        }
        catch (ParseException ex) {
            throw new JsonParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError tErr) {
            int col = p.token.endColumn;
            int line = p.token.endLine;
            throw new JsonParseException(tErr.getMessage(), line, col);
        }
    }

    public static void parseAny(Reader reader) {
        JSONParserJavaCC.parseAny(reader, new JSONPrinter());
    }

    public static void parseAny(Reader reader, JSONHandler handler) {
        JSON_Parser p = new JSON_Parser(reader);
        p.setHandler(handler);
        try {
            p.any();
        }
        catch (ParseException ex) {
            throw new JsonParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError tErr) {
            int col = p.token.endColumn;
            int line = p.token.endLine;
            throw new JsonParseException(tErr.getMessage(), line, col);
        }
    }
}

