/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.json.io;

import java.io.OutputStream;
import java.util.Set;
import java.util.TreeSet;
import org.openjena.atlas.io.IndentedWriter;
import org.openjena.atlas.json.JsonArray;
import org.openjena.atlas.json.JsonBoolean;
import org.openjena.atlas.json.JsonNull;
import org.openjena.atlas.json.JsonNumber;
import org.openjena.atlas.json.JsonObject;
import org.openjena.atlas.json.JsonString;
import org.openjena.atlas.json.JsonValue;
import org.openjena.atlas.json.JsonVisitor;
import org.openjena.atlas.lib.BitsInt;
import org.openjena.atlas.lib.Chars;

public class JsonWriter
implements JsonVisitor {
    static boolean writeJavaScript = false;
    IndentedWriter out;

    public JsonWriter() {
        this(IndentedWriter.stdout);
    }

    public JsonWriter(OutputStream ps) {
        this(new IndentedWriter(ps));
    }

    public JsonWriter(IndentedWriter ps) {
        this.out = ps;
    }

    public void startOutput() {
    }

    public void finishOutput() {
        this.out.flush();
    }

    public void visit(JsonObject jsonObject) {
        this.out.print("{ ");
        this.out.incIndent();
        boolean first = true;
        boolean multiLine = false;
        Set<String> x = jsonObject.keySet();
        TreeSet<String> y = new TreeSet<String>(x);
        for (String k : y) {
            if (!first) {
                this.out.print(",");
                this.out.println();
                multiLine = true;
            }
            first = false;
            this.outputQuotedString(k, true);
            this.out.print(" : ");
            this.out.incIndent();
            jsonObject.get(k).visit(this);
            this.out.decIndent();
        }
        this.out.decIndent();
        if (multiLine) {
            this.out.ensureStartOfLine();
        } else {
            this.out.print(" ");
        }
        this.out.print("} ");
    }

    private void outputQuotedString(String string, boolean allowBareWords) {
        int quoteChar = 34;
        int len = string.length();
        if (writeJavaScript) {
            boolean safeBareWord = true;
            if (len != 0) {
                safeBareWord = this.isA2Z(string.charAt(0));
            }
            if (safeBareWord) {
                for (int i = 1; i < len; ++i) {
                    char ch = string.charAt(i);
                    if (this.isA2ZN(ch)) continue;
                    safeBareWord = false;
                    break;
                }
            }
            if (safeBareWord) {
                this.out.print(string);
                return;
            }
        }
        if (writeJavaScript) {
            quoteChar = 39;
        }
        this.out.print((char)quoteChar);
        block12: for (int i = 0; i < len; ++i) {
            int ch = string.charAt(i);
            if (ch == quoteChar) {
                JsonWriter.esc(this.out, (char)quoteChar);
                continue;
            }
            switch (ch) {
                case 34: {
                    JsonWriter.esc(this.out, '\"');
                    continue block12;
                }
                case 39: {
                    JsonWriter.esc(this.out, '\'');
                    continue block12;
                }
                case 92: {
                    JsonWriter.esc(this.out, '\\');
                    continue block12;
                }
                case 47: {
                    if (i > 0 && string.charAt(i - 1) == '<') {
                        JsonWriter.esc(this.out, '/');
                        continue block12;
                    }
                    this.out.print((char)ch);
                    continue block12;
                }
                case 8: {
                    JsonWriter.esc(this.out, 'b');
                    continue block12;
                }
                case 12: {
                    JsonWriter.esc(this.out, 'f');
                    continue block12;
                }
                case 10: {
                    JsonWriter.esc(this.out, 'n');
                    continue block12;
                }
                case 13: {
                    JsonWriter.esc(this.out, 'r');
                    continue block12;
                }
                case 9: {
                    JsonWriter.esc(this.out, 't');
                    continue block12;
                }
                default: {
                    if (ch < 32 || ch >= 127 && ch <= 159 || ch >= 8192 && ch < 8448) {
                        this.out.print("\\u");
                        int x = ch;
                        x = JsonWriter.oneHex(this.out, x, 3);
                        x = JsonWriter.oneHex(this.out, x, 2);
                        x = JsonWriter.oneHex(this.out, x, 1);
                        x = JsonWriter.oneHex(this.out, x, 0);
                        continue block12;
                    }
                    this.out.print((char)ch);
                }
            }
        }
        this.out.print((char)quoteChar);
    }

    private boolean isA2Z(int ch) {
        return JsonWriter.range(ch, 'a', 'z') || JsonWriter.range(ch, 'A', 'Z');
    }

    private boolean isA2ZN(int ch) {
        return JsonWriter.range(ch, 'a', 'z') || JsonWriter.range(ch, 'A', 'Z') || JsonWriter.range(ch, '0', '9');
    }

    private boolean isNumeric(int ch) {
        return JsonWriter.range(ch, '0', '9');
    }

    private static boolean isWhitespace(int ch) {
        return ch == 32 || ch == 9 || ch == 13 || ch == 10 || ch == 12;
    }

    private static boolean isNewlineChar(int ch) {
        return ch == 13 || ch == 10;
    }

    private static boolean range(int ch, char a, char b) {
        return ch >= a && ch <= b;
    }

    private static void esc(IndentedWriter out, char ch) {
        out.print('\\');
        out.print(ch);
    }

    private static int oneHex(IndentedWriter out, int x, int i) {
        int y = BitsInt.unpack(x, 4 * i, 4 * i + 4);
        char charHex = Chars.hexDigits[y];
        out.print(charHex);
        return BitsInt.clear(x, 4 * i, 4 * i + 4);
    }

    public void visit(JsonArray jsonArray) {
        boolean multiLine;
        boolean bl = multiLine = jsonArray.size() > 1;
        if (multiLine) {
            this.out.ensureStartOfLine();
        }
        this.out.print("[ ");
        this.out.incIndent();
        boolean first = true;
        for (JsonValue elt : jsonArray) {
            if (!first) {
                this.out.print(",");
                this.out.println();
                multiLine = true;
            }
            first = false;
            elt.visit(this);
        }
        this.out.decIndent();
        if (multiLine) {
            this.out.ensureStartOfLine();
        } else {
            this.out.print(" ");
        }
        this.out.print("] ");
    }

    public void visit(JsonString jsonString) {
        this.outputQuotedString(jsonString.value(), false);
    }

    public void visit(JsonNumber jsonNumber) {
        this.out.print(jsonNumber.value().toString());
    }

    public void visit(JsonBoolean jsonBoolean) {
        String x = jsonBoolean.value() ? "true" : "false";
        this.out.print(x);
    }

    public void visit(JsonNull jsonNull) {
        this.out.print("null");
    }
}

