/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.json.io;

import java.io.OutputStream;
import java.util.Stack;
import org.openjena.atlas.io.IndentedWriter;
import org.openjena.atlas.lib.Ref;

public class JSWriter {
    private IndentedWriter out = IndentedWriter.stdout;
    Stack<Ref<Boolean>> stack = new Stack();

    public JSWriter() {
        this(IndentedWriter.stdout);
    }

    public JSWriter(OutputStream ps) {
        this(new IndentedWriter(ps));
    }

    public JSWriter(IndentedWriter ps) {
        this.out = ps;
    }

    public void startOutput() {
    }

    public void finishOutput() {
        this.out.flush();
    }

    public void startObject() {
        this.startCompound();
        this.out.print("{ ");
        this.out.incIndent();
    }

    public void finishObject() {
        this.out.decIndent();
        if (this.isFirst()) {
            this.out.print("}");
        } else {
            this.out.ensureStartOfLine();
            this.out.println("}");
        }
        this.finishCompound();
    }

    public void key(String key) {
        if (this.isFirst()) {
            this.out.println();
            this.setNotFirst();
        } else {
            this.out.println(" ,");
        }
        this.value(key);
        this.out.print(" : ");
    }

    public void pair(String key, String value) {
        this.key(key);
        this.value(value);
    }

    public void startArray() {
        this.startCompound();
        this.out.print("[ ");
    }

    public void finishArray() {
        this.out.print(" ]");
        this.finishCompound();
    }

    public void arrayElement(String str2) {
        if (this.isFirst()) {
            this.setNotFirst();
        } else {
            this.out.print(", ");
        }
        this.value(str2);
    }

    private void startCompound() {
        this.stack.push(new Ref<Boolean>(true));
    }

    private void finishCompound() {
        this.stack.pop();
    }

    private boolean isFirst() {
        return this.stack.peek().getValue();
    }

    private void setNotFirst() {
        this.stack.peek().setValue(false);
    }

    private void value(String x) {
        this.out.print("\"");
        this.out.print(x);
        this.out.print("\"");
    }
}

