/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.json;

import org.openjena.atlas.io.IndentedLineBuffer;
import org.openjena.atlas.io.IndentedWriter;
import org.openjena.atlas.io.Printable;
import org.openjena.atlas.json.JsonArray;
import org.openjena.atlas.json.JsonBoolean;
import org.openjena.atlas.json.JsonNumber;
import org.openjena.atlas.json.JsonObject;
import org.openjena.atlas.json.JsonString;
import org.openjena.atlas.json.JsonVisitor;
import org.openjena.atlas.json.io.JsonWriter;

public abstract class JsonValue
implements Printable {
    public boolean isObject() {
        return false;
    }

    public JsonObject getAsObject() {
        return null;
    }

    public boolean isArray() {
        return this instanceof JsonArray;
    }

    public JsonArray getAsArray() {
        return null;
    }

    public boolean isPrimitive() {
        return this.isString() || this.isNumber() || this.isBoolean() || this.isNull();
    }

    public boolean isNull() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public JsonNumber getNumber() {
        return null;
    }

    public boolean isString() {
        return false;
    }

    public JsonString getString() {
        return null;
    }

    public boolean isBoolean() {
        return false;
    }

    public JsonBoolean getBoolean() {
        return null;
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract void visit(JsonVisitor var1);

    public String toString() {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        this.output(buff);
        return buff.asString();
    }

    public void output(IndentedWriter out) {
        JsonWriter w = new JsonWriter(out);
        w.startOutput();
        this.visit(w);
        w.finishOutput();
    }
}

