/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.json;

import com.hp.hpl.jena.util.FileUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.openjena.atlas.io.IndentedWriter;
import org.openjena.atlas.io.PeekReader;
import org.openjena.atlas.json.JsonValue;
import org.openjena.atlas.json.io.JSONMaker;
import org.openjena.atlas.json.io.JsonWriter;
import org.openjena.atlas.json.io.parser.JSONParser2;

public class JSON {
    private static final boolean useJavaCC = false;

    public static JsonValue parse(String string) {
        return JSON.parse(new StringReader(string));
    }

    public static JsonValue parseAny(String string) {
        return JSON.parseAny(new StringReader(string));
    }

    public static JsonValue read(String filename) {
        try {
            Reader f = FileUtils.asUTF8((InputStream)new FileInputStream(filename));
            PeekReader r = PeekReader.make(f);
            return JSON.parse(r);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("File not found: " + filename);
        }
    }

    public static JsonValue readAny(String filename) {
        try {
            Reader f = FileUtils.asUTF8((InputStream)new FileInputStream(filename));
            PeekReader r = PeekReader.make(f);
            return JSON.parseAny(r);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("File not found: " + filename);
        }
    }

    private static JsonValue parse(Reader r) {
        JSONMaker maker = new JSONMaker();
        JSON._parse(r, maker);
        return maker.jsonValue();
    }

    private static JsonValue parseAny(Reader r) {
        JSONMaker maker = new JSONMaker();
        JSON._parseAny(r, maker);
        return maker.jsonValue();
    }

    private static void _parse(Reader r, JSONMaker maker) {
        JSONParser2.parse(r, maker);
    }

    private static void _parseAny(Reader r, JSONMaker maker) {
        JSONParser2.parseAny(r, maker);
    }

    public static void write(OutputStream output, JsonValue jValue) {
        JsonWriter w = new JsonWriter(output);
        jValue.visit(w);
    }

    public static void write(IndentedWriter output, JsonValue jValue) {
        JsonWriter w = new JsonWriter(output);
        jValue.visit(w);
    }

    public static void write(JsonValue jValue) {
        JSON.write(IndentedWriter.stdout, jValue);
        IndentedWriter.stdout.flush();
    }
}

