/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeekIterator<T>
implements Iterator<T> {
    private final Iterator<T> iter;
    private boolean finished = false;
    private T slot;

    public PeekIterator(Iterator<T> iter) {
        this.iter = iter;
        this.fill();
    }

    private void fill() {
        if (this.finished) {
            return;
        }
        if (this.iter.hasNext()) {
            this.slot = this.iter.next();
        } else {
            this.finished = true;
            this.slot = null;
        }
    }

    @Override
    public boolean hasNext() {
        return !this.finished;
    }

    public T peek() {
        if (this.finished) {
            throw new NoSuchElementException();
        }
        return this.slot;
    }

    public T peekOrNull() {
        if (this.finished) {
            return null;
        }
        return this.slot;
    }

    @Override
    public T next() {
        if (this.finished) {
            throw new NoSuchElementException();
        }
        T x = this.slot;
        this.fill();
        return x;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

