/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.iterator;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.openjena.atlas.iterator.AccString;
import org.openjena.atlas.iterator.Accumulate;
import org.openjena.atlas.iterator.Action;
import org.openjena.atlas.iterator.ActionCount;
import org.openjena.atlas.iterator.Filter;
import org.openjena.atlas.iterator.FilterOutNulls;
import org.openjena.atlas.iterator.FilterUnique;
import org.openjena.atlas.iterator.Iterator2;
import org.openjena.atlas.iterator.NullIterator;
import org.openjena.atlas.iterator.SingletonIterator;
import org.openjena.atlas.iterator.Transform;
import org.openjena.atlas.lib.ActionKeyValue;
import org.openjena.atlas.lib.Closeable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Iter<T>
implements Iterable<T>,
Iterator<T> {
    private Iterator<T> iterator;

    public static <T> Iterator<T> singleton(T item) {
        return new SingletonIterator<T>(item);
    }

    public static <T> Iterator<T> nullIterator() {
        return new NullIterator();
    }

    public static <T> Set<T> toSet(Iterable<? extends T> stream) {
        return Iter.toSet(stream.iterator());
    }

    public static <T> Set<T> toSet(Iterator<? extends T> stream) {
        Accumulate action = new Accumulate<T, Set<T>>(){
            private Set<T> acc = null;

            @Override
            public void accumulate(T item) {
                this.acc.add(item);
            }

            @Override
            public Set<T> get() {
                return this.acc;
            }

            @Override
            public void start() {
                this.acc = new HashSet();
            }

            @Override
            public void finish() {
            }
        };
        return (Set)Iter.reduce(stream, action);
    }

    public static <T> List<T> toList(Iterable<? extends T> stream) {
        return Iter.toList(stream.iterator());
    }

    public static <T> List<T> toList(Iterator<? extends T> stream) {
        Accumulate action = new Accumulate<T, List<T>>(){
            private List<T> acc = null;

            @Override
            public void accumulate(T item) {
                this.acc.add(item);
            }

            @Override
            public List<T> get() {
                return this.acc;
            }

            @Override
            public void start() {
                this.acc = new ArrayList();
            }

            @Override
            public void finish() {
            }
        };
        return (List)Iter.reduce(stream, action);
    }

    public static <T, R> R foldLeft(Iterable<? extends T> stream, Folder<T, R> function, R value) {
        return Iter.foldLeft(stream.iterator(), function, value);
    }

    public static <T, R> R foldLeft(Iterator<? extends T> stream, Folder<T, R> function, R value) {
        while (stream.hasNext()) {
            T item = stream.next();
            value = function.eval(value, item);
        }
        return value;
    }

    public static <T, R> R foldRight(Iterable<? extends T> stream, Folder<T, R> function, R value) {
        return Iter.foldRight(stream.iterator(), function, value);
    }

    public static <T, R> R foldRight(Iterator<? extends T> stream, Folder<T, R> function, R value) {
        if (!stream.hasNext()) {
            return value;
        }
        T item = stream.next();
        return function.eval(Iter.foldRight(stream, function, value), item);
    }

    public static <T, R> R reduce(Iterable<? extends T> stream, Accumulate<T, R> aggregator) {
        return Iter.reduce(stream.iterator(), aggregator);
    }

    public static <T, R> R reduce(Iterator<? extends T> stream, Accumulate<T, R> aggregator) {
        aggregator.start();
        while (stream.hasNext()) {
            T item = stream.next();
            aggregator.accumulate(item);
        }
        aggregator.finish();
        return aggregator.get();
    }

    public static <T> void apply(Iterable<? extends T> stream, Action<T> action) {
        Iter.apply(stream.iterator(), action);
    }

    public static <T> void apply(Iterator<? extends T> stream, Action<T> action) {
        while (stream.hasNext()) {
            T item = stream.next();
            action.apply(item);
        }
    }

    public static <K, V> void apply(Map<K, V> map, ActionKeyValue<K, V> action) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            action.apply(entry.getKey(), entry.getValue());
        }
    }

    public static <T> Iterator<T> filter(Iterable<? extends T> stream, Filter<T> filter) {
        return Iter.filter(stream.iterator(), filter);
    }

    public static <T> Iterator<T> filter(final Iterator<? extends T> stream, final Filter<T> filter) {
        Iterator iter = new Iterator<T>(){
            boolean finished = false;
            T slot;

            @Override
            public boolean hasNext() {
                if (this.finished) {
                    return false;
                }
                while (this.slot == null) {
                    if (!stream.hasNext()) {
                        this.finished = true;
                        break;
                    }
                    Object nextItem = stream.next();
                    if (!filter.accept(nextItem)) continue;
                    this.slot = nextItem;
                    break;
                }
                return this.slot != null;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    Object returnValue = this.slot;
                    this.slot = null;
                    return returnValue;
                }
                throw new NoSuchElementException("filter.next");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("filter.remove");
            }
        };
        return iter;
    }

    public static <T> Iterator<T> notFilter(Iterable<? extends T> stream, Filter<T> filter) {
        return Iter.notFilter(stream.iterator(), filter);
    }

    public static <T> Iterator<T> notFilter(Iterator<? extends T> stream, Filter<T> filter) {
        Filter<T> flippedFilter = InvertedFilter.invert(filter);
        return Iter.filter(stream, flippedFilter);
    }

    public static <T> boolean every(Iterable<? extends T> stream, Filter<T> filter) {
        for (T item : stream) {
            if (filter.accept(item)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean every(Iterator<? extends T> stream, Filter<T> filter) {
        while (stream.hasNext()) {
            T item = stream.next();
            if (filter.accept(item)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean some(Iterable<? extends T> stream, Filter<T> filter) {
        for (T item : stream) {
            if (!filter.accept(item)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean some(Iterator<? extends T> stream, Filter<T> filter) {
        while (stream.hasNext()) {
            T item = stream.next();
            if (!filter.accept(item)) continue;
            return true;
        }
        return false;
    }

    public static <T, R> Iterator<R> map(Iterable<? extends T> stream, Transform<T, R> converter) {
        return Iter.map(stream.iterator(), converter);
    }

    public static <T, R> Iterator<R> map(final Iterator<? extends T> stream, final Transform<T, R> converter) {
        Iterator iter = new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return stream.hasNext();
            }

            @Override
            public R next() {
                return converter.convert(stream.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("map.remove");
            }
        };
        return iter;
    }

    public static <T> Iterator<T> operate(Iterable<? extends T> stream, Action<T> converter) {
        return Iter.operate(stream.iterator(), converter);
    }

    public static <T> Iterator<T> operate(final Iterator<? extends T> stream, final Action<T> action) {
        Iterator iter = new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return stream.hasNext();
            }

            @Override
            public T next() {
                Object t = stream.next();
                action.apply(t);
                return t;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("operate.remove");
            }
        };
        return iter;
    }

    public static <T> Iterator<T> print(Iterator<? extends T> stream) {
        return Iter.print(System.out, stream);
    }

    public static <T> Iterator<T> print(final PrintStream out, Iterator<? extends T> stream) {
        Action action = new Action<T>(){

            @Override
            public void apply(T item) {
                out.println(item);
            }
        };
        return Iter.operate(stream, action);
    }

    public static <T> Iterator<T> append(Iterable<T> iter1, Iterable<T> iter2) {
        return Iterator2.create(Iter.iterator(iter1), Iter.iterator(iter2));
    }

    public static <T> Iterator<T> append(Iterator<? extends T> iter1, Iterator<? extends T> iter2) {
        return Iterator2.create(iter1, iter2);
    }

    private static <T> Iterator<T> iterator(Iterable<T> iter) {
        return iter == null ? null : iter.iterator();
    }

    public static <T> Iterator<T> distinct(Iterable<T> iter) {
        return Iter.distinct(iter.iterator());
    }

    public static <T> Iterator<T> distinct(Iterator<T> iter) {
        return Iter.filter(iter, new FilterUnique());
    }

    public static <T> Iterator<T> removeNulls(Iterable<T> iter) {
        return Iter.filter(iter, new FilterOutNulls());
    }

    public static <T> Iterator<T> removeNulls(Iterator<T> iter) {
        return Iter.filter(iter, new FilterOutNulls());
    }

    public static <T> Iterator<T> convert(Iterator<?> iterator) {
        return iterator;
    }

    public static <T> long count(Iterable<T> iterator) {
        ActionCount action = new ActionCount();
        Iter.apply(iterator, action);
        return action.getCount();
    }

    public static <T> long count(Iterator<T> iterator) {
        ActionCount action = new ActionCount();
        Iter.apply(iterator, action);
        return action.getCount();
    }

    public static <T> String asString(Iterable<T> stream) {
        return Iter.asString(stream, new AccString());
    }

    public static <T> String asString(Iterator<T> stream) {
        return Iter.asString(stream, new AccString());
    }

    public static <T> String asString(Iter<T> stream) {
        return Iter.asString(stream, new AccString());
    }

    public static <T> String asString(Iterable<T> stream, String sep) {
        return Iter.asString(stream, new AccString(sep));
    }

    public static <T> String asString(Iterator<T> stream, String sep) {
        return Iter.asString(stream, new AccString(sep));
    }

    public static <T> String asString(Iter<T> stream, String sep) {
        return Iter.asString(stream.iterator(), new AccString(sep));
    }

    public static <T> String asString(Iterable<T> stream, AccString<T> formatter) {
        return (String)Iter.reduce(stream, formatter);
    }

    public static <T> String asString(Iterator<T> stream, AccString<T> formatter) {
        return (String)Iter.reduce(stream, formatter);
    }

    public static <T> String asString(Iter<T> stream, AccString<T> formatter) {
        return (String)Iter.reduce(stream.iterator(), formatter);
    }

    public static <T> void close(Iterator<T> iter) {
        if (iter instanceof Closeable) {
            ((Closeable)((Object)iter)).close();
        }
    }

    public static <T> Iterator<T> debug(Iterator<T> stream) {
        Transform x = new Transform<T, T>(){

            @Override
            public T convert(T item) {
                System.out.println(item);
                return item;
            }
        };
        return Iter.map(stream, x);
    }

    public static <T> Iter<T> iter(Iter<T> iter) {
        return iter;
    }

    public static <T> Iter<T> iter(Collection<T> collection) {
        return Iter.iter(collection.iterator());
    }

    public static <T> Iter<T> iter(Iterator<T> iterator) {
        if (iterator instanceof Iter) {
            return (Iter)iterator;
        }
        return new Iter<T>(iterator);
    }

    public static <T> Iter<T> iter(Iterable<T> iterable) {
        if (iterable instanceof Iter) {
            return (Iter)iterable;
        }
        return new Iter<T>(iterable.iterator());
    }

    public static <T> Iter<T> concat(Iter<T> iter1, Iter<T> iter2) {
        if (iter1 == null) {
            return iter2;
        }
        if (iter2 == null) {
            return iter1;
        }
        return iter1.append(iter2);
    }

    public static <T> Iterator<T> concat(Iterator<T> iter1, Iterator<T> iter2) {
        if (iter1 == null) {
            return iter2;
        }
        if (iter2 == null) {
            return iter1;
        }
        return Iter.iter(iter1).append(Iter.iter(iter2));
    }

    private Iter(Iterator<T> iterator) {
        this.iterator = iterator;
    }

    public Set<T> toSet() {
        return Iter.toSet(this.iterator);
    }

    public List<T> toList() {
        return Iter.toList(this.iterator);
    }

    public Iter<T> filter(Filter<T> filter) {
        return Iter.iter(Iter.filter(this.iterator, filter));
    }

    public boolean every(Filter<T> filter) {
        return Iter.every(this.iterator, filter);
    }

    public boolean some(Filter<T> filter) {
        return Iter.some(this.iterator, filter);
    }

    public Iter<T> removeNulls() {
        return this.filter(new FilterOutNulls());
    }

    public <R> Iter<R> map(Transform<T, R> converter) {
        return Iter.iter(Iter.map(this.iterator, converter));
    }

    public Iter<T> operate(Action<T> action) {
        return Iter.iter(Iter.operate(this.iterator, action));
    }

    public <R> R reduce(Accumulate<T, R> aggregator) {
        return Iter.reduce(this.iterator, aggregator);
    }

    public void apply(Action<T> action) {
        Iter.apply(this.iterator, action);
    }

    public Iter<T> append(Iterator<T> iter) {
        return new Iter<T>(Iterator2.create(this.iterator, iter));
    }

    public long count() {
        ActionCount action = new ActionCount();
        this.apply(action);
        return action.getCount();
    }

    public String asString() {
        return Iter.asString(this.iterator);
    }

    public String asString(String sep) {
        return Iter.asString(this.iterator, sep);
    }

    public Iter<T> distinct() {
        return new Iter<T>(Iter.distinct(this.iterator()));
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    public static <T> Iter<T> singletonIter(T item) {
        return new Iter<T>(new SingletonIterator<T>(item));
    }

    public static <T> Iter<T> nullIter() {
        return new Iter(new NullIterator());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InvertedFilter<T>
    implements Filter<T> {
        private Filter<T> baseFilter;

        public static <T> Filter<T> invert(Filter<T> filter) {
            return new InvertedFilter<T>(filter);
        }

        private InvertedFilter(Filter<T> baseFilter) {
            this.baseFilter = baseFilter;
        }

        @Override
        public boolean accept(T item) {
            return !this.baseFilter.accept(item);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Folder<X, Y> {
        public Y eval(Y var1, X var2);
    }
}

