/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.io;

import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.util.FileUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class IndentedWriter {
    public static final IndentedWriter stdout = new IndentedWriter(System.out);
    public static final IndentedWriter stderr = new IndentedWriter(System.err);
    protected Writer out = null;
    protected static final int INDENT = 2;
    protected int unitIndent = 2;
    protected int currentIndent = 0;
    protected int column = 0;
    protected int row = 1;
    protected boolean lineNumbers = false;
    protected boolean startingNewLine = true;
    private char padChar = (char)32;
    private String padString = null;
    protected boolean flatMode = false;
    private char lastChar = '\u0000';
    private static int WidthLineNumber = 3;

    public IndentedWriter() {
        this(System.out, false);
    }

    protected IndentedWriter(IndentedWriter other) {
        this.out = other.out;
        this.lineNumbers = other.lineNumbers;
        if (other.column != this.column || other.row != this.row) {
            throw new ARQInternalErrorException("Can only clone am unstarted IndentedWriter");
        }
    }

    public IndentedWriter(OutputStream outStream) {
        this(outStream, false);
    }

    public IndentedWriter(OutputStream outStream, boolean withLineNumbers) {
        this(FileUtils.asPrintWriterUTF8((OutputStream)outStream), withLineNumbers);
    }

    protected IndentedWriter(Writer writer) {
        this(writer, false);
    }

    protected IndentedWriter(Writer writer, boolean withLineNumbers) {
        this.out = writer;
        this.lineNumbers = withLineNumbers;
        this.startingNewLine = true;
    }

    public void print(Object obj) {
        String s = "null";
        if (obj != null) {
            s = obj.toString();
        }
        for (int i = 0; i < s.length(); ++i) {
            this.printOneChar(s.charAt(i));
        }
    }

    public void printf(String formatStr, Object ... args) {
        this.print(String.format(formatStr, args));
    }

    public void print(char ch) {
        this.printOneChar(ch);
    }

    public void println(Object obj) {
        this.print(obj);
        this.newline();
    }

    public void println(char ch) {
        this.print(ch);
        this.newline();
    }

    public void println() {
        this.newline();
    }

    private void printOneChar(char ch) {
        if (ch == '\n' && this.lastChar == '\r') {
            this.lastChar = ch;
            return;
        }
        this.lineStart();
        this.lastChar = ch;
        if (ch == '\n' || ch == '\r') {
            this.newline();
            return;
        }
        this.write(ch);
        ++this.column;
    }

    private void write(char ch) {
        try {
            this.out.write(ch);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void write(String s) {
        try {
            this.out.write(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void print(String s, int n) {
        for (int i = 0; i < n; ++i) {
            this.print(s);
        }
    }

    public void print(char ch, int n) {
        this.lineStart();
        for (int i = 0; i < n; ++i) {
            this.printOneChar(ch);
        }
    }

    public void newline() {
        this.lineStart();
        if (!this.flatMode) {
            this.write('\n');
        }
        this.startingNewLine = true;
        ++this.row;
        this.column = 0;
        this.flush();
    }

    private boolean atStartOfLine() {
        return this.column <= this.currentIndent;
    }

    public void ensureStartOfLine() {
        if (!this.atStartOfLine()) {
            this.newline();
        }
    }

    public void close() {
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void pad() {
        if (this.startingNewLine && this.currentIndent > 0) {
            this.lineStart();
        }
        this.padInt();
    }

    public void pad(int col) {
        this.pad(col, false);
    }

    public void pad(int col, boolean absoluteColumn) {
        if (!absoluteColumn) {
            col += this.currentIndent;
        }
        int spaces = col - this.column;
        for (int i = 0; i < spaces; ++i) {
            this.write(' ');
            ++this.column;
        }
    }

    private void padInt() {
        if (this.padString == null) {
            for (int i = this.column; i < this.currentIndent; ++i) {
                this.write(this.padChar);
                ++this.column;
            }
        } else {
            for (int i = this.column; i < this.currentIndent; i += this.padString.length()) {
                this.write(this.padString);
                this.column += this.padString.length();
            }
        }
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.column;
    }

    public int getIndent() {
        return this.currentIndent;
    }

    public int getCurrentOffset() {
        int x = this.getCol() - this.getIndent();
        if (x >= 0) {
            return x;
        }
        return 0;
    }

    public boolean hasLineNumbers() {
        return this.lineNumbers;
    }

    public void setLineNumbers(boolean lineNumbers) {
        this.lineNumbers = lineNumbers;
    }

    public boolean inFlatMode() {
        return this.flatMode;
    }

    public void setFlatMode(boolean flatMode) {
        this.flatMode = flatMode;
    }

    public char getPadChar() {
        return this.padChar;
    }

    public void setPadChar(char ch) {
        this.padChar = ch;
    }

    public String getPadString() {
        return this.padString;
    }

    public void setPadString(String str2) {
        this.padString = str2;
        this.unitIndent = str2.length();
    }

    public void incIndent() {
        this.incIndent(this.unitIndent);
    }

    public void incIndent(int x) {
        if (!this.flatMode) {
            this.currentIndent += x;
        }
    }

    public void decIndent() {
        this.decIndent(this.unitIndent);
    }

    public void decIndent(int x) {
        if (!this.flatMode) {
            this.currentIndent -= x;
        }
    }

    public void setUnitIndent(int x) {
        this.unitIndent = x;
    }

    public int getUnitIndent() {
        return this.unitIndent;
    }

    public void setAbsoluteIndent(int x) {
        this.currentIndent = x;
    }

    public boolean atLineStart() {
        return this.startingNewLine;
    }

    private void lineStart() {
        if (this.flatMode) {
            if (this.startingNewLine && this.row > 1) {
                this.write(' ');
            }
            this.startingNewLine = false;
            return;
        }
        if (this.startingNewLine) {
            this.insertLineNumber();
        }
        this.padInt();
        this.startingNewLine = false;
    }

    private void insertLineNumber() {
        if (!this.lineNumbers) {
            return;
        }
        String s = Integer.toString(this.row);
        for (int i = 0; i < WidthLineNumber - s.length(); ++i) {
            this.write(' ');
        }
        this.write(s);
        this.write(' ');
    }
}

