/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.io;

import com.hp.hpl.jena.sparql.util.ALog;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.WritableByteChannel;
import org.openjena.atlas.AtlasException;
import org.openjena.atlas.lib.Bytes;
import org.openjena.atlas.lib.Sink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BufferingWriter
extends Writer {
    private static Logger log = LoggerFactory.getLogger(BufferingWriter.class);
    private static final int SIZE = 8192;
    private static final int BLOB_SIZE = 4096;
    private final int blockSize;
    private final int blobSize;
    private ByteBuffer buffer = ByteBuffer.allocate(8192);
    private Sink<ByteBuffer> out;
    private char[] oneChar = new char[1];

    public static BufferingWriter create(WritableByteChannel out) {
        return BufferingWriter.create(out, 8192);
    }

    public static BufferingWriter create(WritableByteChannel out, int size) {
        return new BufferingWriter(new SinkChannel(out), size, size / 2);
    }

    public static BufferingWriter create(OutputStream out, int size) {
        return new BufferingWriter(new SinkOutputStream(out), size, size / 2);
    }

    public BufferingWriter(Sink<ByteBuffer> sink) {
        this(sink, 8192, 4096);
    }

    public BufferingWriter(Sink<ByteBuffer> sink, int size, int blobSize) {
        this.out = sink;
        this.blockSize = size;
        this.blobSize = blobSize;
    }

    public void output(CharSequence string) {
        boolean largeBlob;
        int space = string.length();
        boolean bl = largeBlob = (space = 4 * space) > this.blobSize;
        if (largeBlob || this.blockSize - this.bufferSize() < space) {
            this.flush();
        }
        if (largeBlob) {
            ByteBuffer bb = ByteBuffer.allocate(space);
            Bytes.toByteBuffer(string, bb);
            BufferingWriter.send(this.out, bb);
            return;
        }
        Bytes.toByteBuffer(string, this.buffer);
    }

    private int bufferSize() {
        return this.buffer.position();
    }

    public void output(char[] chars) {
        this.output(CharBuffer.wrap(chars));
    }

    public void output(char[] chars, int start, int finish) {
        this.output(CharBuffer.wrap(chars, start, finish));
    }

    public void output(int ch) {
        this.oneChar[0] = (char)ch;
        this.output(this.oneChar);
        this.oneChar[0] = '\u0000';
    }

    private static void send(Sink<ByteBuffer> out, ByteBuffer bb) {
        if (log.isDebugEnabled()) {
            log.debug("send: " + bb);
        }
        if (out == null) {
            System.out.write(bb.array(), 0, bb.position());
            try {
                System.out.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        if (bb.position() == 0) {
            ALog.warn(BufferingWriter.class, "Sending zero bytes");
        }
        bb.flip();
        out.send(bb);
    }

    private static void exception(IOException ex) {
        throw new AtlasException(ex);
    }

    @Override
    public void close() {
        this.out.close();
    }

    @Override
    public void flush() {
        if (this.bufferSize() > 0) {
            BufferingWriter.send(this.out, this.buffer);
            this.out.flush();
            this.buffer.clear();
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.output(CharBuffer.wrap(cbuf, off, len));
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    @Override
    public void write(String string) throws IOException {
        this.output(string);
    }

    @Override
    public void write(int ch) throws IOException {
        this.output(ch);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SinkOutputStream
    implements Sink<ByteBuffer> {
        private OutputStream out;

        public SinkOutputStream(OutputStream out) {
            this.out = out;
        }

        @Override
        public void send(ByteBuffer bb) {
            try {
                this.out.write(bb.array(), 0, bb.limit());
            }
            catch (IOException ex) {
                BufferingWriter.exception(ex);
            }
        }

        @Override
        public void close() {
            try {
                this.out.close();
            }
            catch (IOException ex) {
                BufferingWriter.exception(ex);
            }
        }

        @Override
        public void flush() {
            try {
                this.out.flush();
            }
            catch (IOException ex) {
                BufferingWriter.exception(ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SinkBuffer
    implements Sink<ByteBuffer> {
        private ByteBuffer out;

        public SinkBuffer(ByteBuffer out) {
            this.out = out;
        }

        @Override
        public void send(ByteBuffer bb) {
            this.out.put(bb);
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SinkChannel
    implements Sink<ByteBuffer> {
        private WritableByteChannel out;

        public SinkChannel(WritableByteChannel out) {
            this.out = out;
        }

        @Override
        public void send(ByteBuffer bb) {
            try {
                this.out.write(bb);
            }
            catch (IOException ex) {
                BufferingWriter.exception(ex);
            }
        }

        @Override
        public void close() {
            try {
                this.out.close();
            }
            catch (IOException ex) {
                BufferingWriter.exception(ex);
            }
        }

        @Override
        public void flush() {
        }
    }
}

