/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.core.QueryCheckException;
import com.hp.hpl.jena.sparql.lang.ParserRegistry;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.SSEParseException;
import com.hp.hpl.jena.sparql.sse.WriterSSE;
import com.hp.hpl.jena.sparql.sse.builders.BuildException;
import org.openjena.atlas.io.IndentedLineBuffer;
import org.openjena.atlas.io.IndentedWriter;

public class QueryUtils {
    public static void checkQuery(Query query2, boolean optimizeAlgebra) {
        QueryUtils.checkParse(query2);
        QueryUtils.checkOp(query2, optimizeAlgebra);
    }

    public static void checkOp(Query query2, boolean optimizeAlgebra) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        Op op = Algebra.compile(query2);
        if (optimizeAlgebra) {
            op = Algebra.optimize(op);
        }
        WriterSSE.out((IndentedWriter)buff, op, (Prologue)query2);
        String str2 = buff.toString();
        try {
            Op op2 = SSE.parseOp(str2);
            if (op.hashCode() != op2.hashCode()) {
                throw new QueryCheckException("reparsed algebra expression hashCode does not equal algebra from query");
            }
            if (!op.equals(op2)) {
                throw new QueryCheckException("reparsed algebra expression does not equal query algebra");
            }
        }
        catch (SSEParseException ex) {
            System.err.println(str2);
            throw ex;
        }
        catch (BuildException ex) {
            System.err.println(str2);
            throw ex;
        }
    }

    public static void checkParse(Query query2) {
        if (!ParserRegistry.get().containsFactory(query2.getSyntax())) {
            return;
        }
        IndentedLineBuffer buff = new IndentedLineBuffer();
        query2.serialize(buff, query2.getSyntax());
        String tmp = buff.toString();
        Query query22 = null;
        try {
            String baseURI = null;
            if (!query2.explicitlySetBaseURI()) {
                baseURI = query2.getBaseURI();
            }
            if ((query22 = QueryFactory.create(tmp, baseURI, query2.getSyntax())) == null) {
                return;
            }
        }
        catch (UnsupportedOperationException ex) {
            return;
        }
        catch (QueryException ex) {
            System.err.println(tmp);
            throw new QueryCheckException("could not parse output query", (Throwable)((Object)ex));
        }
        if (query2.hashCode() != query22.hashCode()) {
            throw new QueryCheckException("reparsed query hashCode does not equal parsed input query");
        }
        if (!query2.equals(query22)) {
            throw new QueryCheckException("reparsed output does not equal parsed input");
        }
    }
}

