/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.QueryEngineRegistry;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.sse.WriterSSE;
import com.hp.hpl.jena.sparql.util.PrintSerializable;
import com.hp.hpl.jena.sparql.util.Printable;
import com.hp.hpl.jena.sparql.util.Utils;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.openjena.atlas.io.IndentedLineBuffer;
import org.openjena.atlas.io.IndentedWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintUtils {
    private static Fmt itemFmt = new Fmt(){

        public String fmt(Object thing) {
            if (thing == null) {
                return "<null>";
            }
            return thing.toString();
        }
    };

    public static String toString(Printable f) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        f.output(buff);
        return buff.toString();
    }

    public static String toString(PrintSerializable item, PrefixMapping pmap) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        SerializationContext sCxt = new SerializationContext(pmap);
        item.output(buff, sCxt);
        return buff.toString();
    }

    public static String toString(PrintSerializable item) {
        return PrintUtils.toString(item, null);
    }

    public static void output(PrintSerializable item, IndentedWriter out) {
        out.print("(");
        out.print(Utils.className(item));
        out.print(")");
    }

    public static <T> void printList(IndentedWriter out, Collection<T> list, String sep, Fmt itemFmt) {
        String sep$ = "";
        Iterator<T> iter = list.iterator();
        while (iter.hasNext()) {
            out.print(sep$);
            sep$ = sep;
            T obj = iter.next();
            out.print(itemFmt.fmt(obj));
        }
    }

    public static <T> void printList(IndentedWriter out, Collection<T> list, String sep) {
        PrintUtils.printList(out, list, sep, itemFmt);
    }

    public static <T> void printList(IndentedWriter out, Collection<T> list) {
        PrintUtils.printList(out, list, " ");
    }

    public static <T> void printList(PrintStream out, Collection<T> list, String sep, Fmt itemFmt) {
        String sep$ = "";
        Iterator<T> iter = list.iterator();
        while (iter.hasNext()) {
            out.print(sep$);
            sep$ = sep;
            T obj = iter.next();
            out.print(itemFmt.fmt(obj));
        }
    }

    public static <T> void printList(PrintStream out, List<T> list, String sep) {
        PrintUtils.printList(out, list, sep, itemFmt);
    }

    public static <T> void printList(PrintStream out, List<T> list) {
        PrintUtils.printList(out, list, " ");
    }

    public static void printPlan(Query query2, QueryExecution qe) {
        QueryEngineFactory f = QueryEngineRegistry.findFactory(query2, qe.getDataset().asDatasetGraph(), ARQ.getContext());
        if (f == null) {
            System.err.println("printPlan: Unknown engine type: " + Utils.className(qe));
        }
        Plan plan = f.create(query2, qe.getDataset().asDatasetGraph(), BindingRoot.create(), ARQ.getContext());
        SerializationContext sCxt = new SerializationContext(query2);
        IndentedWriter out = IndentedWriter.stdout;
        plan.output(out, sCxt);
        out.flush();
    }

    public static void printQuery(Query query2) {
        IndentedWriter out = IndentedWriter.stdout;
        PrintUtils.printQuery(out, query2);
    }

    public static void printQuery(IndentedWriter out, Query query2) {
        PrintUtils.printQuery(out, query2, Syntax.defaultSyntax);
    }

    public static void printQuery(IndentedWriter out, Query query2, Syntax syntax) {
        query2.serialize(out, syntax);
        out.flush();
    }

    public static void printOp(Query query2, boolean optimize) {
        IndentedWriter out = IndentedWriter.stdout;
        PrintUtils.printOp(out, query2, optimize);
    }

    public static void printOp(IndentedWriter out, Query query2, boolean printOptimized) {
        Op op = Algebra.compile(query2);
        if (printOptimized) {
            op = Algebra.optimize(op);
        }
        WriterSSE.out(out, op, (Prologue)query2);
        out.flush();
    }

    public static void printQuad(Query query2, boolean printOptimized) {
        IndentedWriter out = IndentedWriter.stdout;
        PrintUtils.printQuad(out, query2, printOptimized);
    }

    public static void printQuad(IndentedWriter out, Query query2, boolean printOptimized) {
        Op op = Algebra.compile(query2);
        if (printOptimized) {
            op = Algebra.optimize(op);
        }
        op = Algebra.toQuadForm(op);
        WriterSSE.out(out, op, (Prologue)query2);
        out.flush();
    }

    public static interface Fmt {
        public String fmt(Object var1);
    }
}

