/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse.writers;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprFunctionOp;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.ExprVisitor;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.sse.writers.WriterOp;
import org.openjena.atlas.io.IndentedLineBuffer;
import org.openjena.atlas.io.IndentedWriter;

public class WriterExpr {
    static final boolean ONELINE = true;

    public static String asString(Expr expr) {
        IndentedLineBuffer b = new IndentedLineBuffer();
        WriterExpr.output((IndentedWriter)b, expr, null);
        return b.asString();
    }

    public static void output(IndentedWriter out, ExprList exprs, SerializationContext sCxt) {
        WriterExpr.output(out, exprs, true, true, sCxt);
    }

    public static void output(IndentedWriter out, ExprList exprs, boolean withTag, boolean unlist, SerializationContext sCxt) {
        if (exprs.size() == 0) {
            out.print("()");
            return;
        }
        if (exprs.size() == 1 && unlist) {
            WriterExpr.output(out, exprs.get(0), sCxt);
            return;
        }
        if (withTag) {
            out.print("(exprlist ");
        } else {
            out.print("(");
        }
        for (int i = 0; i < exprs.size(); ++i) {
            if (i != 0) {
                out.print(" ");
            }
            WriterExpr.output(out, exprs.get(i), sCxt);
        }
        out.print(")");
    }

    private static void outputTail(IndentedWriter out, ExprList exprs, SerializationContext sCxt) {
        for (int i = 0; i < exprs.size(); ++i) {
            out.print(" ");
            WriterExpr.output(out, exprs.get(i), sCxt);
        }
        out.print(")");
    }

    public static void output(IndentedWriter out, Expr expr, SerializationContext sCxt) {
        FmtExprPrefixVisitor fmt = new FmtExprPrefixVisitor(out, sCxt);
        expr.visit(fmt);
    }

    static class FmtExprPrefixVisitor
    implements ExprVisitor {
        IndentedWriter out;
        SerializationContext context;

        public FmtExprPrefixVisitor(IndentedWriter writer, SerializationContext cxt) {
            this.out = writer;
            this.context = cxt;
        }

        public void startVisit() {
        }

        public void visit(ExprFunction func) {
            Expr expr;
            this.out.print("(");
            String n = null;
            if (func.getOpName() != null) {
                n = func.getOpName();
            }
            if (n == null) {
                n = func.getFunctionPrintName(this.context);
            }
            this.out.print(n);
            this.out.incIndent();
            int i = 1;
            while ((expr = func.getArg(i)) != null) {
                this.out.print(' ');
                expr.visit(this);
                ++i;
            }
            this.out.print(")");
            this.out.decIndent();
        }

        public void visit(ExprFunctionOp funcOp) {
            this.out.print("(");
            int x = this.out.getCurrentOffset();
            this.out.incIndent(x);
            this.out.print(funcOp.getFunctionName(this.context));
            this.out.incIndent();
            Op op = funcOp.getOp();
            if (FmtExprPrefixVisitor.oneLine(op)) {
                this.out.print(" ");
            } else {
                this.out.ensureStartOfLine();
            }
            WriterOp.outputNoPrologue(this.out, funcOp.getOp(), this.context);
            this.out.decIndent();
            this.out.decIndent(x);
            this.out.print(")");
        }

        private static boolean oneLine(Op op) {
            BasicPattern bgp;
            return OpBGP.isBGP(op) && (bgp = ((OpBGP)op).getPattern()).getList().size() <= 1;
        }

        public void visit(NodeValue nv) {
            this.out.print(nv.asQuotedString(this.context));
        }

        public void visit(ExprVar nv) {
            this.out.print(nv.toPrefixString());
        }

        public void finishVisit() {
            this.out.flush();
        }

        private void endLine() {
            this.out.print(' ');
        }
    }
}

