/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse.builders;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.TriplePath;
import com.hp.hpl.jena.sparql.path.P_Alt;
import com.hp.hpl.jena.sparql.path.P_Inverse;
import com.hp.hpl.jena.sparql.path.P_Link;
import com.hp.hpl.jena.sparql.path.P_Mod;
import com.hp.hpl.jena.sparql.path.P_NegPropSet;
import com.hp.hpl.jena.sparql.path.P_Path0;
import com.hp.hpl.jena.sparql.path.P_ReverseLink;
import com.hp.hpl.jena.sparql.path.P_Seq;
import com.hp.hpl.jena.sparql.path.Path;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.sse.ItemLocation;
import com.hp.hpl.jena.sparql.sse.builders.BuilderLib;
import com.hp.hpl.jena.sparql.sse.builders.BuilderNode;
import java.util.HashMap;
import java.util.Map;

public class BuilderPath {
    protected Map<String, Build> dispatch = new HashMap<String, Build>();
    protected final Build buildNotOneOf = new Build(){

        public Path make(ItemList list) {
            BuilderLib.checkLengthAtLeast(1, list, "path: negative property set: must be at least one element");
            P_NegPropSet pNegClass = new P_NegPropSet();
            for (int i = 1; i < list.size(); ++i) {
                Item item = list.get(i);
                Path p = BuilderPath.this.build(item);
                if (!(p instanceof P_Path0)) {
                    BuilderLib.broken(item, "Not a property or reverse property");
                }
                pNegClass.add((P_Path0)p);
            }
            return pNegClass;
        }
    };
    protected final Build buildSeq = new Build(){

        public Path make(ItemList list) {
            BuilderLib.checkLength(3, 3, list, "path seq: wanted 2 arguments");
            Path left = BuilderPath.this.build(list, 1);
            Path right = BuilderPath.this.build(list, 2);
            return new P_Seq(left, right);
        }
    };
    protected final Build buildAlt = new Build(){

        public Path make(ItemList list) {
            BuilderLib.checkLength(3, 3, list, "path alt: wanted 2 arguments");
            Path left = BuilderPath.this.build(list, 1);
            Path right = BuilderPath.this.build(list, 2);
            return new P_Alt(left, right);
        }
    };
    protected final Build buildMod = new Build(){

        public Path make(ItemList list) {
            BuilderLib.checkLength(4, 4, list, "path mod: wanted 3 arguments");
            long min2 = BuilderPath.modInt(list.get(1));
            long max2 = BuilderPath.modInt(list.get(2));
            Path path = BuilderPath.this.build(list, 3);
            return new P_Mod(path, min2, max2);
        }
    };
    protected final Build buildReverse = new Build(){

        public Path make(ItemList list) {
            BuilderLib.checkLength(2, 2, list, "path reverse: wanted 1 argument");
            Path path = BuilderPath.this.build(list, 1);
            return new P_Inverse(path);
        }
    };
    protected final Build buildRev = new Build(){

        public Path make(ItemList list) {
            BuilderLib.checkLength(2, 2, list, "path reverse link: wanted 1 argument");
            return new P_ReverseLink(list.get(1).getNode());
        }
    };

    public static Path buildPath(Item item) {
        BuilderPath bob = new BuilderPath();
        return bob.build(item);
    }

    public static TriplePath buildTriplePath(ItemList list) {
        if (list.size() != 3 && list.size() != 4) {
            BuilderLib.broken((ItemLocation)list, "Not a triple path", list);
        }
        if (list.size() == 4) {
            if (!list.get(0).isSymbol("path")) {
                BuilderLib.broken(list, "Not a triple path");
            }
            list = list.cdr();
        }
        Node s = BuilderNode.buildNode(list.get(0));
        Path p = BuilderPath.buildPath(list.get(1));
        Node o = BuilderNode.buildNode(list.get(2));
        return new TriplePath(s, p, o);
    }

    private BuilderPath() {
        this.dispatch.put("seq", this.buildSeq);
        this.dispatch.put("alt", this.buildAlt);
        this.dispatch.put("mod", this.buildMod);
        this.dispatch.put("reverse", this.buildReverse);
        this.dispatch.put("rev", this.buildRev);
        this.dispatch.put("notoneof", this.buildNotOneOf);
    }

    private Path build(Item item) {
        if (item.isNode()) {
            if (item.getNode().isURI()) {
                return new P_Link(item.getNode());
            }
            BuilderLib.broken(item, "Attempt to build path from a plain node");
        }
        if (item.isSymbol()) {
            BuilderLib.broken(item, "Attempt to build path from a bare symbol");
        }
        return this.build(item.getList());
    }

    private Path build(ItemList list) {
        Item head = list.get(0);
        if (!head.isSymbol()) {
            return this.build(head);
        }
        String tag = head.getSymbol();
        Build bob = this.findBuild(tag);
        if (bob != null) {
            return bob.make(list);
        }
        BuilderLib.broken(head, "Unrecognized path operation: " + tag);
        return null;
    }

    protected Build findBuild(String str2) {
        for (String key : this.dispatch.keySet()) {
            if (!str2.equalsIgnoreCase(key)) continue;
            return this.dispatch.get(key);
        }
        return null;
    }

    protected Path build(ItemList list, int idx) {
        return this.build(list.get(idx));
    }

    static long modInt(Item item) {
        if ("*".equals(item.getSymbol())) {
            return P_Mod.INF;
        }
        return BuilderNode.buildInt(item);
    }

    static interface Build {
        public Path make(ItemList var1);
    }
}

