/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.serializer;

import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.PrefixMapping2;
import java.util.Map;
import org.openjena.atlas.io.IndentedWriter;

public class PrologueSerializer {
    public static void output(IndentedWriter out, Prologue prologue) {
        PrologueSerializer.printBase(prologue, out);
        PrologueSerializer.printPrefixes(prologue, out);
    }

    private static void printBase(Prologue prologue, IndentedWriter out) {
        if (prologue.getBaseURI() != null && prologue.explicitlySetBaseURI()) {
            out.print("BASE    ");
            out.print("<" + prologue.getBaseURI() + ">");
            out.newline();
        }
    }

    public static void printPrefixes(Prologue prologue, IndentedWriter out) {
        Map<String, String> pmap = null;
        if (prologue.getPrefixMapping() instanceof PrefixMapping2) {
            PrefixMapping2 pm2 = (PrefixMapping2)prologue.getPrefixMapping();
            pmap = pm2.getNsPrefixMap(false);
        } else {
            Map<String, String> _pmap;
            pmap = _pmap = prologue.getPrefixMapping().getNsPrefixMap();
        }
        if (pmap.size() > 0) {
            for (String k : pmap.keySet()) {
                String v = pmap.get(k);
                out.print("PREFIX  ");
                out.print(k);
                out.print(':');
                out.print(' ', 4 - k.length());
                out.print(' ');
                out.print(FmtUtils.stringForURI(v));
                out.newline();
            }
        }
    }
}

