/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.procedure;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterRepeatApply;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.procedure.Procedure;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.sse.writers.WriterExpr;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.IterLib;
import com.hp.hpl.jena.sparql.util.PrintSerializableBase;
import org.openjena.atlas.io.IndentedWriter;

public abstract class ProcedureBase
extends PrintSerializableBase
implements Procedure {
    private Node procId;
    private ExprList args;

    public void build(Node procId, ExprList args, ExecutionContext execCxt) {
        this.procId = procId;
        this.args = args;
    }

    public final QueryIterator proc(QueryIterator input, ExecutionContext execCxt) {
        return new RepeatApplyIterator(input, execCxt);
    }

    public abstract QueryIterator exec(Binding var1, Node var2, ExprList var3, ExecutionContext var4);

    public void output(IndentedWriter out, SerializationContext sCxt) {
        out.print("Procedure [" + FmtUtils.stringForNode(this.procId, sCxt) + "]");
        out.print("[");
        out.print(this.args.toString());
        out.print("]");
        out.println();
    }

    class RepeatApplyIterator
    extends QueryIterRepeatApply {
        private ExecutionContext execCxt;
        private Node name;

        public RepeatApplyIterator(QueryIterator input, ExecutionContext execCxt) {
            super(input, execCxt);
        }

        protected QueryIterator nextStage(Binding binding) {
            QueryIterator iter = ProcedureBase.this.exec(binding, this.name, ProcedureBase.this.args, super.getExecContext());
            if (iter == null) {
                iter = IterLib.noResults(this.execCxt);
            }
            return iter;
        }

        protected void details(IndentedWriter out, SerializationContext sCxt) {
            out.print("Procedure [" + FmtUtils.stringForNode(this.name, sCxt) + "]");
            WriterExpr.output(out, ProcedureBase.this.args, sCxt);
            out.println();
        }
    }
}

