/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.pfunction;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.NodeConst;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.PrintSerializableBase;
import com.hp.hpl.jena.sparql.util.PrintUtils;
import java.util.ArrayList;
import java.util.List;
import org.openjena.atlas.io.IndentedWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropFuncArg
extends PrintSerializableBase {
    private List<Node> argList = null;
    private Node arg = null;

    public PropFuncArg(List<Node> argList, Node arg) {
        if (argList == null) {
            this.arg = arg;
            return;
        }
        this.argList = argList;
        if (argList.isEmpty()) {
            this.arg = NodeConst.nodeNil;
        }
    }

    public PropFuncArg(List<Node> argList) {
        this.argList = argList;
    }

    public PropFuncArg(Node arg) {
        this.arg = arg;
    }

    public Node getArg() {
        return this.arg;
    }

    public List<Node> getArgList() {
        return this.argList;
    }

    public int getArgListSize() {
        return this.argList == null ? -1 : this.argList.size();
    }

    public Node getArg(int index) {
        if (this.argList == null) {
            return null;
        }
        return this.argList.get(index);
    }

    public int hashCode() {
        if (this.isNode()) {
            return this.arg.hashCode();
        }
        return ((Object)this.argList).hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PropFuncArg)) {
            return false;
        }
        PropFuncArg pfArg = (PropFuncArg)other;
        if (this.isNode()) {
            return this.arg.equals((Object)pfArg.arg);
        }
        return ((Object)this.argList).equals(pfArg.argList);
    }

    public boolean isList() {
        return this.argList != null;
    }

    public boolean isNode() {
        return this.arg != null;
    }

    public ExprList asExprList(PropFuncArg pfArg) {
        ExprList exprList = new ExprList();
        if (pfArg.isNode()) {
            Node n = pfArg.getArg();
            Expr expr = ExprUtils.nodeToExpr(n);
            exprList.add(expr);
            return exprList;
        }
        for (Node n : pfArg.getArgList()) {
            Expr expr = ExprUtils.nodeToExpr(n);
            exprList.add(expr);
        }
        return exprList;
    }

    @Override
    public void output(IndentedWriter out, final SerializationContext sCxt) {
        if (this.argList == null && this.arg == null) {
            out.print("<<null>>");
        }
        if (this.argList != null) {
            out.print("(");
            PrintUtils.printList(out, this.argList, " ", new PrintUtils.Fmt(){

                public String fmt(Object thing) {
                    return FmtUtils.stringForNode((Node)thing, sCxt);
                }
            });
            out.print(")");
        }
        if (this.arg != null) {
            out.print(FmtUtils.stringForNode(this.arg));
        }
    }

    public PropFuncArg evalIfExists(Binding binding) {
        if (this.isNode()) {
            return new PropFuncArg(PropFuncArg.evalIfExistsOneArg(binding, this.arg));
        }
        ArrayList<Node> newArgList = new ArrayList<Node>();
        for (Node n : this.argList) {
            newArgList.add(PropFuncArg.evalIfExistsOneArg(binding, n));
        }
        return new PropFuncArg(newArgList);
    }

    private static Node evalIfExistsOneArg(Binding binding, Node n) {
        if (!n.isVariable()) {
            return n;
        }
        Node r = binding.get(Var.alloc(n));
        return r != null ? r : n;
    }
}

