/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.mgt;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Symbol;
import org.openjena.atlas.lib.StrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Explain {
    public static final Logger logExec = LoggerFactory.getLogger((String)"com.hp.hpl.jena.tdb.exec");
    public static final Symbol symLogExec = ARQConstants.allocSymbol("logExec");

    public static void explain(Query query2, Context context) {
        Explain.explain("Query", query2, context);
    }

    public static void explain(String message, Query query2, Context context) {
        if (Explain.explaining(context)) {
            Explain._explain(message, query2.toString(), false);
        }
    }

    public static void explain(Op op, Context context) {
        Explain.explain("Algebra", op, context);
    }

    public static void explain(String message, Op op, Context context) {
        if (Explain.explaining(context)) {
            Explain._explain(message, op.toString(), false);
        }
    }

    public static void explain(BasicPattern bgp, Context context) {
        Explain.explain("BGP", bgp, context);
    }

    public static void explain(String message, BasicPattern bgp, Context context) {
        if (Explain.explaining(context)) {
            Explain._explain(message, bgp.toString(), false);
        }
    }

    private static void _explain(String reason, String explanation, boolean oneLine) {
        if (oneLine) {
            // empty if block
        }
        while (explanation.endsWith("\n") || explanation.endsWith("\r")) {
            explanation = StrUtils.chop(explanation);
        }
        explanation = reason + "\n" + explanation;
        Explain._explain(explanation);
    }

    private static void _explain(String explanation) {
        logExec.info(explanation);
    }

    public static void explain(Context context, String message) {
        if (Explain.explaining(context)) {
            Explain._explain(message);
        }
    }

    public static boolean explaining(Context context) {
        return context.isTrue(symLogExec) && logExec.isInfoEnabled();
    }
}

