/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.aggregate.AggAvg;
import com.hp.hpl.jena.sparql.expr.aggregate.AggAvgDistinct;
import com.hp.hpl.jena.sparql.expr.aggregate.AggCount;
import com.hp.hpl.jena.sparql.expr.aggregate.AggCountDistinct;
import com.hp.hpl.jena.sparql.expr.aggregate.AggCountVar;
import com.hp.hpl.jena.sparql.expr.aggregate.AggCountVarDistinct;
import com.hp.hpl.jena.sparql.expr.aggregate.AggGroupConcat;
import com.hp.hpl.jena.sparql.expr.aggregate.AggGroupConcatDistinct;
import com.hp.hpl.jena.sparql.expr.aggregate.AggMax;
import com.hp.hpl.jena.sparql.expr.aggregate.AggMaxDistinct;
import com.hp.hpl.jena.sparql.expr.aggregate.AggMin;
import com.hp.hpl.jena.sparql.expr.aggregate.AggMinDistinct;
import com.hp.hpl.jena.sparql.expr.aggregate.AggSample;
import com.hp.hpl.jena.sparql.expr.aggregate.AggSampleDistinct;
import com.hp.hpl.jena.sparql.expr.aggregate.AggSum;
import com.hp.hpl.jena.sparql.expr.aggregate.AggSumDistinct;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.util.ALog;

public class AggregatorFactory {
    public static Aggregator createCount(boolean distinct) {
        return distinct ? new AggCountDistinct() : new AggCount();
    }

    public static Aggregator createCountExpr(boolean distinct, Expr expr) {
        return distinct ? new AggCountVarDistinct(expr) : new AggCountVar(expr);
    }

    public static Aggregator createSum(boolean distinct, Expr expr) {
        return distinct ? new AggSumDistinct(expr) : new AggSum(expr);
    }

    public static Aggregator createMin(boolean distinct, Expr expr) {
        return distinct ? new AggMinDistinct(expr) : new AggMin(expr);
    }

    public static Aggregator createMax(boolean distinct, Expr expr) {
        return distinct ? new AggMaxDistinct(expr) : new AggMax(expr);
    }

    public static Aggregator createAvg(boolean distinct, Expr expr) {
        return distinct ? new AggAvgDistinct(expr) : new AggAvg(expr);
    }

    public static Aggregator createSample(boolean distinct, Expr expr) {
        return distinct ? new AggSampleDistinct(expr) : new AggSample(expr);
    }

    public static Aggregator createGroupConcat(boolean distinct, Expr expr, String separator) {
        return distinct ? new AggGroupConcatDistinct(expr, separator) : new AggGroupConcat(expr, separator);
    }

    private static Aggregator err(String label) {
        ALog.fatal(AggregatorFactory.class, "Not implemented: " + label);
        return null;
    }
}

