/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingKey;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import java.util.HashMap;
import java.util.Map;

public abstract class AggregatorBase
implements Aggregator {
    private Map<BindingKey, Accumulator> buckets = new HashMap<BindingKey, Accumulator>();

    protected AggregatorBase() {
    }

    public final void accumulate(BindingKey key, Binding binding, FunctionEnv functionEnv) {
        Accumulator acc = this.buckets.get(key);
        if (acc == null) {
            acc = this.createAccumulator();
            this.buckets.put(key, acc);
        }
        acc.accumulate(binding, functionEnv);
    }

    protected abstract Accumulator createAccumulator();

    public abstract Node getValueEmpty();

    public Node getValue(BindingKey key) {
        Accumulator acc = this.buckets.get(key);
        if (acc == null) {
            throw new ARQInternalErrorException("Null for accumulator");
        }
        NodeValue nv = acc.getValue();
        if (nv == null) {
            return null;
        }
        return nv.asNode();
    }

    public String key() {
        return this.toPrefixString();
    }

    public abstract String toString();

    public abstract String toPrefixString();
}

