/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.Renamer;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.expr.nodevalue.XSDFuncOp;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.sse.writers.WriterExpr;
import com.hp.hpl.jena.sparql.util.ExprUtils;

public class AggSum
extends AggregatorBase {
    private static final NodeValue noValuesToSum = NodeValue.nvZERO;
    private Expr expr;

    public AggSum(Expr expr) {
        this.expr = expr;
    }

    public Aggregator copy() {
        return new AggSum(this.expr);
    }

    public Aggregator copyRename(Renamer renamer) {
        return new AggSum(this.expr.copySubstitute(null, false, renamer));
    }

    public String toString() {
        return "sum(" + ExprUtils.fmtSPARQL(this.expr) + ")";
    }

    public String toPrefixString() {
        return "(sum " + WriterExpr.asString(this.expr) + ")";
    }

    protected Accumulator createAccumulator() {
        return new AccSum();
    }

    private final Expr getExpr() {
        return this.expr;
    }

    public boolean equalsAsExpr(Aggregator other) {
        if (!(other instanceof AggSum)) {
            return false;
        }
        AggSum agg = (AggSum)other;
        return agg.getExpr().equals(this.getExpr());
    }

    public Node getValueEmpty() {
        return NodeValue.toNode(noValuesToSum);
    }

    class AccSum
    implements Accumulator {
        private NodeValue total = null;

        public void accumulate(Binding binding, FunctionEnv functionEnv) {
            try {
                NodeValue nv = AggSum.this.expr.eval(binding, functionEnv);
                if (nv.isNumber()) {
                    this.total = this.total == null ? nv : XSDFuncOp.add(nv, this.total);
                }
            }
            catch (ExprEvalException exprEvalException) {
                // empty catch block
            }
        }

        public NodeValue getValue() {
            return this.total;
        }
    }
}

