/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.Renamer;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.sse.writers.WriterExpr;
import com.hp.hpl.jena.sparql.util.ExprUtils;

public class AggSample
extends AggregatorBase {
    private final Expr expr;

    public AggSample(Expr expr) {
        this.expr = expr;
    }

    public Aggregator copy() {
        return new AggSample(this.expr);
    }

    public Aggregator copyRename(Renamer renamer) {
        return new AggSample(this.expr.copySubstitute(null, false, renamer));
    }

    public String toString() {
        return "sample(" + ExprUtils.fmtSPARQL(this.expr) + ")";
    }

    public String toPrefixString() {
        return "(sample " + WriterExpr.asString(this.expr) + ")";
    }

    protected Accumulator createAccumulator() {
        return new AccSample();
    }

    protected final Expr getExpr() {
        return this.expr;
    }

    public boolean equalsAsExpr(Aggregator other) {
        if (!(other instanceof AggSample)) {
            return false;
        }
        AggSample agg = (AggSample)other;
        return agg.getExpr().equals(this.getExpr());
    }

    public Node getValueEmpty() {
        return null;
    }

    class AccSample
    implements Accumulator {
        private NodeValue sampleSoFar = null;

        public void accumulate(Binding binding, FunctionEnv functionEnv) {
            try {
                NodeValue nv = AggSample.this.expr.eval(binding, functionEnv);
                if (this.sampleSoFar == null) {
                    this.sampleSoFar = nv;
                    return;
                }
            }
            catch (ExprEvalException exprEvalException) {
                // empty catch block
            }
        }

        public NodeValue getValue() {
            return this.sampleSoFar;
        }
    }
}

