/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.Renamer;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.sse.writers.WriterExpr;
import com.hp.hpl.jena.sparql.util.ExprUtils;

public class AggMin
extends AggregatorBase {
    protected final Expr expr;

    public AggMin(Expr expr) {
        this.expr = expr;
    }

    public Aggregator copy() {
        return new AggMin(this.expr);
    }

    public Aggregator copyRename(Renamer renamer) {
        return new AggMin(this.expr.copySubstitute(null, false, renamer));
    }

    public String toString() {
        return "min(" + ExprUtils.fmtSPARQL(this.expr) + ")";
    }

    public String toPrefixString() {
        return "(min " + WriterExpr.asString(this.expr) + ")";
    }

    protected Accumulator createAccumulator() {
        return new AccMin();
    }

    protected final Expr getExpr() {
        return this.expr;
    }

    public boolean equalsAsExpr(Aggregator other) {
        if (!(other instanceof AggMin)) {
            return false;
        }
        AggMin agg = (AggMin)other;
        return agg.getExpr().equals(this.getExpr());
    }

    public Node getValueEmpty() {
        return null;
    }

    class AccMin
    implements Accumulator {
        private NodeValue minSoFar = null;
        static final boolean DEBUG = false;

        public void accumulate(Binding binding, FunctionEnv functionEnv) {
            try {
                NodeValue nv = AggMin.this.expr.eval(binding, functionEnv);
                if (this.minSoFar == null) {
                    this.minSoFar = nv;
                    return;
                }
                int x = NodeValue.compareAlways(this.minSoFar, nv);
                if (x > 0) {
                    this.minSoFar = nv;
                }
            }
            catch (ExprEvalException exprEvalException) {
                // empty catch block
            }
        }

        public NodeValue getValue() {
            return this.minSoFar;
        }
    }
}

