/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.Renamer;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.sse.writers.WriterExpr;
import com.hp.hpl.jena.sparql.util.ExprUtils;

public class AggMax
extends AggregatorBase {
    protected final Expr expr;

    public AggMax(Expr expr) {
        this.expr = expr;
    }

    public Aggregator copy() {
        return new AggMax(this.expr);
    }

    public Aggregator copyRename(Renamer renamer) {
        return new AggMax(this.expr.copySubstitute(null, false, renamer));
    }

    public String toString() {
        return "max(" + ExprUtils.fmtSPARQL(this.expr) + ")";
    }

    public String toPrefixString() {
        return "(max " + WriterExpr.asString(this.expr) + ")";
    }

    protected Accumulator createAccumulator() {
        return new AccMax();
    }

    protected final Expr getExpr() {
        return this.expr;
    }

    public boolean equalsAsExpr(Aggregator other) {
        if (!(other instanceof AggMax)) {
            return false;
        }
        AggMax agg = (AggMax)other;
        return agg.getExpr().equals(this.getExpr());
    }

    public Node getValueEmpty() {
        return null;
    }

    class AccMax
    implements Accumulator {
        private NodeValue maxSoFar = null;
        static final boolean DEBUG = false;

        public void accumulate(Binding binding, FunctionEnv functionEnv) {
            try {
                NodeValue nv = AggMax.this.expr.eval(binding, functionEnv);
                if (this.maxSoFar == null) {
                    this.maxSoFar = nv;
                    return;
                }
                int x = NodeValue.compareAlways(this.maxSoFar, nv);
                if (x < 0) {
                    this.maxSoFar = nv;
                }
            }
            catch (ExprEvalException exprEvalException) {
                // empty catch block
            }
        }

        public NodeValue getValue() {
            return this.maxSoFar;
        }
    }
}

