/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.Renamer;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorDistinctExpr;
import com.hp.hpl.jena.sparql.expr.aggregate.AggGroupConcat;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.sse.writers.WriterExpr;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import com.hp.hpl.jena.sparql.util.Utils;
import org.openjena.atlas.lib.StrUtils;

public class AggGroupConcatDistinct
extends AggregatorBase {
    private final Expr expr;
    private final String separatorSeen;
    private final String separator;

    public AggGroupConcatDistinct(Expr expr, String separator) {
        this(expr, separator != null ? separator : " ", separator);
    }

    private AggGroupConcatDistinct(Expr expr, String separator, String separatorSeen) {
        this.expr = expr;
        this.separatorSeen = separatorSeen;
        this.separator = separator;
    }

    public Aggregator copy() {
        return new AggGroupConcatDistinct(this.expr, this.separator, this.separatorSeen);
    }

    public Aggregator copyRename(Renamer renamer) {
        return new AggGroupConcat(this.expr.copySubstitute(null, false, renamer), this.separator);
    }

    public String toString() {
        String x = "GROUP_CONCAT(DISTINCT " + ExprUtils.fmtSPARQL(this.expr);
        if (this.separatorSeen != null) {
            String y = StrUtils.escapeString(this.separatorSeen);
            x = x + "; SEPARATOR='" + y + "'";
        }
        x = x + ")";
        return x;
    }

    public String toPrefixString() {
        String x = "(group_concat distinct ";
        if (this.separatorSeen != null) {
            String y = StrUtils.escapeString(this.separatorSeen);
            x = x + "(separator '" + y + "') ";
        }
        x = x + WriterExpr.asString(this.expr) + ")";
        return x;
    }

    protected Accumulator createAccumulator() {
        return new AccGroupConcatDistinct(this.expr);
    }

    protected final Expr getExpr() {
        return this.expr;
    }

    protected final String getSeparator() {
        return this.separator;
    }

    public boolean equalsAsExpr(Aggregator other) {
        if (!(other instanceof AggGroupConcatDistinct)) {
            return false;
        }
        AggGroupConcatDistinct agg = (AggGroupConcatDistinct)other;
        return Utils.equal(agg.getSeparator(), this.getSeparator()) && agg.getExpr().equals(this.getExpr());
    }

    public Node getValueEmpty() {
        return null;
    }

    class AccGroupConcatDistinct
    extends AccumulatorDistinctExpr {
        private NodeValue sampleSoFar;

        public AccGroupConcatDistinct(Expr expr) {
            super(expr);
            this.sampleSoFar = null;
        }

        public void accumulateDistinct(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
        }

        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        public NodeValue getValue() {
            return this.sampleSoFar;
        }
    }
}

