/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.Renamer;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.sse.writers.WriterExpr;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import com.hp.hpl.jena.sparql.util.Utils;
import org.openjena.atlas.lib.StrUtils;

public class AggGroupConcat
extends AggregatorBase {
    static final String SeparatorDefault = " ";
    private final Expr expr;
    private final String separatorSeen;
    private final String separator;

    public AggGroupConcat(Expr expr, String separator) {
        this(expr, separator != null ? separator : SeparatorDefault, separator);
    }

    private AggGroupConcat(Expr expr, String separator, String separatorSeen) {
        this.expr = expr;
        this.separatorSeen = separatorSeen;
        this.separator = separator;
    }

    public Aggregator copy() {
        return new AggGroupConcat(this.expr, this.separator, this.separatorSeen);
    }

    public Aggregator copyRename(Renamer renamer) {
        return new AggGroupConcat(this.expr.copySubstitute(null, false, renamer), this.separator);
    }

    public String toString() {
        String x = "GROUP_CONCAT(" + ExprUtils.fmtSPARQL(this.expr);
        if (this.separatorSeen != null) {
            String y = StrUtils.escapeString(this.separatorSeen);
            x = x + "; SEPARATOR='" + y + "'";
        }
        x = x + ")";
        return x;
    }

    public String toPrefixString() {
        String x = "(group_concat ";
        if (this.separatorSeen != null) {
            String y = StrUtils.escapeString(this.separatorSeen);
            x = x + "(separator '" + y + "') ";
        }
        x = x + WriterExpr.asString(this.expr) + ")";
        return x;
    }

    protected Accumulator createAccumulator() {
        return new AccGroupConcat();
    }

    protected final Expr getExpr() {
        return this.expr;
    }

    protected final String getSeparator() {
        return this.separator;
    }

    public boolean equalsAsExpr(Aggregator other) {
        if (!(other instanceof AggGroupConcat)) {
            return false;
        }
        AggGroupConcat agg = (AggGroupConcat)other;
        return Utils.equal(agg.getSeparator(), this.getSeparator()) && agg.getExpr().equals(this.getExpr());
    }

    public Node getValueEmpty() {
        return null;
    }

    class AccGroupConcat
    implements Accumulator {
        private StringBuilder stringSoFar = null;

        public void accumulate(Binding binding, FunctionEnv functionEnv) {
            try {
                NodeValue nv = AggGroupConcat.this.expr.eval(binding, functionEnv);
                String str2 = nv.asString();
                if (this.stringSoFar == null) {
                    this.stringSoFar = new StringBuilder(str2);
                    return;
                }
                this.stringSoFar.append(AggGroupConcat.this.separator);
                this.stringSoFar.append(str2);
            }
            catch (ExprEvalException exprEvalException) {
                // empty catch block
            }
        }

        public NodeValue getValue() {
            return NodeValue.makeString(this.stringSoFar.toString());
        }
    }
}

