/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.NodeConst;
import com.hp.hpl.jena.sparql.engine.Renamer;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorDistinctExpr;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;

public class AggCountVarDistinct
extends AggregatorBase {
    private Expr expr;

    public AggCountVarDistinct(Expr expr) {
        this.expr = expr;
    }

    public Aggregator copy() {
        return new AggCountVarDistinct(this.expr);
    }

    public Aggregator copyRename(Renamer renamer) {
        return new AggCountVarDistinct(this.expr.copySubstitute(null, false, renamer));
    }

    public String toString() {
        return "count(distinct " + this.expr + ")";
    }

    public String toPrefixString() {
        return "(count distinct " + this.expr + ")";
    }

    protected Accumulator createAccumulator() {
        return new AccCountVarDistinct();
    }

    private final Expr getExpr() {
        return this.expr;
    }

    public boolean equalsAsExpr(Aggregator other) {
        if (!(other instanceof AggCountVarDistinct)) {
            return false;
        }
        AggCountVarDistinct agg = (AggCountVarDistinct)other;
        return agg.getExpr().equals(this.getExpr());
    }

    public Node getValueEmpty() {
        return NodeConst.nodeZero;
    }

    class AccCountVarDistinct
    extends AccumulatorDistinctExpr {
        private long count;

        public AccCountVarDistinct() {
            super(AggCountVarDistinct.this.expr);
            this.count = 0L;
        }

        public void accumulateDistinct(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            ++this.count;
        }

        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        public NodeValue getValue() {
            return NodeValue.makeInteger(this.count);
        }
    }
}

