/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.NodeConst;
import com.hp.hpl.jena.sparql.engine.Renamer;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorExpr;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;

public class AggCountVar
extends AggregatorBase {
    private Expr expr;

    public AggCountVar(Expr expr) {
        this.expr = expr;
    }

    public Aggregator copy() {
        return new AggCountVar(this.expr);
    }

    public Aggregator copyRename(Renamer renamer) {
        return new AggCountVar(this.expr.copySubstitute(null, false, renamer));
    }

    public String toString() {
        return "count(" + this.expr + ")";
    }

    public String toPrefixString() {
        return "(count " + this.expr + ")";
    }

    protected Accumulator createAccumulator() {
        return new AccCountVar();
    }

    private final Expr getExpr() {
        return this.expr;
    }

    public boolean equalsAsExpr(Aggregator other) {
        if (!(other instanceof AggCountVar)) {
            return false;
        }
        AggCountVar agg = (AggCountVar)other;
        return agg.getExpr().equals(this.getExpr());
    }

    public Node getValueEmpty() {
        return NodeConst.nodeZero;
    }

    private class AccCountVar
    extends AccumulatorExpr {
        private long count;

        public AccCountVar() {
            super(AggCountVar.this.expr);
            this.count = 0L;
        }

        public void accumulate(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            ++this.count;
        }

        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        public NodeValue getValue() {
            return NodeValue.makeInteger(this.count);
        }
    }
}

