/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.NodeConst;
import com.hp.hpl.jena.sparql.engine.Renamer;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorDistinctAll;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;

public class AggCountDistinct
extends AggregatorBase {
    public Aggregator copy() {
        return new AggCountDistinct();
    }

    public Aggregator copyRename(Renamer renamer) {
        return this.copy();
    }

    public String toString() {
        return "count(distinct *)";
    }

    public String toPrefixString() {
        return "(count distinct)";
    }

    protected Accumulator createAccumulator() {
        return new AccCountDistinct();
    }

    public Node getValueEmpty() {
        return NodeConst.nodeZero;
    }

    public boolean equalsAsExpr(Aggregator other) {
        return other instanceof AggCountDistinct;
    }

    static class AccCountDistinct
    extends AccumulatorDistinctAll {
        private long count = 0L;

        public void accumulateDistinct(Binding binding, FunctionEnv functionEnv) {
            ++this.count;
        }

        public NodeValue getValue() {
            return NodeValue.makeInteger(this.count);
        }
    }
}

