/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.Renamer;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorDistinctExpr;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.expr.nodevalue.XSDFuncOp;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.sse.writers.WriterExpr;
import com.hp.hpl.jena.sparql.util.ExprUtils;

public class AggAvgDistinct
extends AggregatorBase {
    private Expr expr;
    private static final NodeValue noValuesToAvg = NodeValue.nvZERO;

    public AggAvgDistinct(Expr expr) {
        this.expr = expr;
    }

    public Aggregator copy() {
        return new AggAvgDistinct(this.expr);
    }

    public Aggregator copyRename(Renamer renamer) {
        return new AggAvgDistinct(this.expr.copySubstitute(null, false, renamer));
    }

    public String toString() {
        return "avg(distinct " + ExprUtils.fmtSPARQL(this.expr) + ")";
    }

    public String toPrefixString() {
        return "(avg distinct " + WriterExpr.asString(this.expr) + ")";
    }

    protected Accumulator createAccumulator() {
        return new AccAvgDistinct(this.expr);
    }

    private final Expr getExpr() {
        return this.expr;
    }

    public boolean equalsAsExpr(Aggregator other) {
        if (!(other instanceof AggAvgDistinct)) {
            return false;
        }
        AggAvgDistinct agg = (AggAvgDistinct)other;
        return agg.getExpr().equals(this.getExpr());
    }

    public Node getValueEmpty() {
        return NodeValue.toNode(noValuesToAvg);
    }

    class AccAvgDistinct
    extends AccumulatorDistinctExpr {
        private NodeValue total;
        private int count;
        static final boolean DEBUG = false;

        public AccAvgDistinct(Expr expr) {
            super(expr);
            this.total = noValuesToAvg;
            this.count = 0;
        }

        protected void accumulateDistinct(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            if (nv.isNumber()) {
                ++this.count;
                this.total = this.total == noValuesToAvg ? nv : XSDFuncOp.add(nv, this.total);
            }
        }

        public NodeValue getValue() {
            if (this.count == 0) {
                return noValuesToAvg;
            }
            NodeValue nvCount = NodeValue.makeInteger(this.count);
            return XSDFuncOp.divide(this.total, nvCount);
        }

        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }
    }
}

