/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.Renamer;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.expr.nodevalue.XSDFuncOp;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.sse.writers.WriterExpr;
import com.hp.hpl.jena.sparql.util.ExprUtils;

public class AggAvg
extends AggregatorBase {
    private Expr expr;
    private static final NodeValue noValuesToAvg = NodeValue.nvZERO;

    public AggAvg(Expr expr) {
        this.expr = expr;
    }

    public Aggregator copy() {
        return new AggAvg(this.expr);
    }

    public Aggregator copyRename(Renamer renamer) {
        return new AggAvg(this.expr.copySubstitute(null, false, renamer));
    }

    public String toString() {
        return "sum(" + ExprUtils.fmtSPARQL(this.expr) + ")";
    }

    public String toPrefixString() {
        return "(sum " + WriterExpr.asString(this.expr) + ")";
    }

    protected Accumulator createAccumulator() {
        return new AccAvg();
    }

    private final Expr getExpr() {
        return this.expr;
    }

    public boolean equalsAsExpr(Aggregator other) {
        if (!(other instanceof AggAvg)) {
            return false;
        }
        AggAvg agg = (AggAvg)other;
        return agg.getExpr().equals(this.getExpr());
    }

    public Node getValueEmpty() {
        return NodeValue.toNode(noValuesToAvg);
    }

    class AccAvg
    implements Accumulator {
        private NodeValue total = AggAvg.access$000();
        private int count = 0;
        static final boolean DEBUG = false;

        public void accumulate(Binding binding, FunctionEnv functionEnv) {
            try {
                NodeValue nv = AggAvg.this.expr.eval(binding, functionEnv);
                if (nv.isNumber()) {
                    ++this.count;
                    this.total = this.total == noValuesToAvg ? nv : XSDFuncOp.add(nv, this.total);
                }
            }
            catch (ExprEvalException exprEvalException) {
                // empty catch block
            }
        }

        public NodeValue getValue() {
            if (this.count == 0) {
                return noValuesToAvg;
            }
            NodeValue nvCount = NodeValue.makeInteger(this.count);
            return XSDFuncOp.divide(this.total, nvCount);
        }
    }
}

