/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import java.util.HashSet;
import java.util.Set;

abstract class AccumulatorDistinctExpr
implements Accumulator {
    private final Set<NodeValue> values = new HashSet<NodeValue>();
    private long errorCount = 0L;
    private final Expr expr;

    protected AccumulatorDistinctExpr(Expr expr) {
        this.expr = expr;
    }

    public final void accumulate(Binding binding, FunctionEnv functionEnv) {
        try {
            NodeValue nv = this.expr.eval(binding, functionEnv);
            if (this.values.contains(nv)) {
                return;
            }
            this.values.add(nv);
            this.accumulateDistinct(nv, binding, functionEnv);
        }
        catch (ExprEvalException ex) {
            ++this.errorCount;
            this.accumulateError(binding, functionEnv);
        }
    }

    protected long getErrorCount() {
        return this.errorCount;
    }

    protected abstract void accumulateDistinct(NodeValue var1, Binding var2, FunctionEnv var3);

    protected abstract void accumulateError(Binding var1, FunctionEnv var2);
}

