/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprFunctionOp;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.ExprVisitor;
import com.hp.hpl.jena.sparql.expr.NodeValue;

public class ExprWalker {
    ExprVisitor visitor;

    public ExprWalker(ExprVisitor visitor) {
        this.visitor = visitor;
    }

    public void walk(Expr expr) {
        expr.visit(this.visitor);
    }

    public static void walk(ExprVisitor visitor, Expr expr) {
        expr.visit(new WalkerBottomUp(visitor));
    }

    public static class WalkerBottomUp
    extends Walker {
        private WalkerBottomUp(ExprVisitor visitor) {
            super(visitor, false);
        }
    }

    public static class WalkerTopDown
    extends Walker {
        private WalkerTopDown(ExprVisitor visitor) {
            super(visitor, true);
        }
    }

    static class Walker
    implements ExprVisitor {
        ExprVisitor visitor;
        boolean topDown = true;

        private Walker(ExprVisitor visitor, boolean topDown) {
            this.visitor = visitor;
            this.topDown = topDown;
        }

        public void startVisit() {
        }

        public void visit(ExprFunction func) {
            Expr expr;
            if (this.topDown) {
                func.visit(this.visitor);
            }
            for (int i = 1; i <= func.numArgs() && (expr = func.getArg(i)) != null; ++i) {
                expr.visit(this);
            }
            if (!this.topDown) {
                func.visit(this.visitor);
            }
        }

        public void visit(ExprFunctionOp funcOp) {
            funcOp.visit(this.visitor);
        }

        public void visit(NodeValue nv) {
            nv.visit(this.visitor);
        }

        public void visit(ExprVar nv) {
            nv.visit(this.visitor);
        }

        public void finishVisit() {
        }
    }
}

