/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.Renamer;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprNode;
import com.hp.hpl.jena.sparql.expr.ExprVisitor;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.VariableNotBoundException;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import org.openjena.atlas.io.IndentedWriter;

public class ExprVar
extends ExprNode {
    protected Var varNode = null;

    public ExprVar(String name) {
        this.varNode = Var.alloc(name);
    }

    public ExprVar(Node n) {
        if (!n.isVariable()) {
            throw new ARQInternalErrorException("Attempt to create a NodeVar from a non variable Node: " + n);
        }
        this.varNode = Var.alloc(n);
    }

    public ExprVar(Var v) {
        this.varNode = v;
    }

    public NodeValue eval(Binding binding, FunctionEnv env) {
        if (binding == null) {
            throw new VariableNotBoundException("Not bound: (no binding): " + (Object)((Object)this.varNode));
        }
        Node v = binding.get(this.varNode);
        if (v == null) {
            throw new VariableNotBoundException("Not bound: variable " + (Object)((Object)this.varNode));
        }
        return NodeValue.makeNode(v);
    }

    public Expr copySubstitute(Binding binding, boolean foldConstants, Renamer renamer) {
        Var v = this.varNode;
        if (renamer != null) {
            v = (Var)renamer.rename((Node)this.varNode);
        }
        if (binding == null || !binding.contains(this.varNode)) {
            return new ExprVar(v);
        }
        return this.eval(binding, null);
    }

    public Expr copy() {
        return new ExprVar(this.varNode);
    }

    public void visit(ExprVisitor visitor) {
        visitor.visit(this);
    }

    public void format(Query query2, IndentedWriter out) {
        out.print('?');
        out.print(this.varNode.getName());
    }

    public int hashCode() {
        return this.varNode.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExprVar)) {
            return false;
        }
        ExprVar nvar = (ExprVar)other;
        return this.getVarName().equals(nvar.getVarName());
    }

    public boolean isVariable() {
        return true;
    }

    public String getVarName() {
        return this.varNode.getName();
    }

    public ExprVar getExprVar() {
        return this;
    }

    public Var asVar() {
        return this.varNode;
    }

    public Node getAsNode() {
        return this.varNode;
    }

    public String toPrefixString() {
        return this.varNode.toString();
    }

    public String asSparqlExpr() {
        return this.varNode.toString();
    }
}

