/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprFunctionOp;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprTransform;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.ExprVisitor;
import com.hp.hpl.jena.sparql.expr.ExprWalker;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.util.ALog;
import java.util.Stack;

public class ExprTransformer {
    private static ExprTransformer singleton = new ExprTransformer();

    public static ExprTransformer get() {
        return singleton;
    }

    public static Expr transform(ExprTransform transform, Expr expr) {
        return ExprTransformer.get().transformation(transform, expr);
    }

    public static ExprList transform(ExprTransform transform, ExprList exprList) {
        return ExprTransformer.get().transformation(transform, exprList);
    }

    private Expr transformation(ExprTransform transform, Expr expr) {
        ApplyExprTransformVisitor v = new ApplyExprTransformVisitor(transform);
        return this.transformation(v, expr);
    }

    private ExprList transformation(ExprTransform transform, ExprList exprList) {
        ApplyExprTransformVisitor v = new ApplyExprTransformVisitor(transform);
        ExprList exprList2 = new ExprList();
        for (Expr expr : exprList) {
            Expr expr2 = this.transformation(v, expr);
            exprList2.add(expr2);
        }
        return exprList2;
    }

    private Expr transformation(ApplyExprTransformVisitor applyVisitor, Expr expr) {
        ExprWalker.walk(applyVisitor, expr);
        return applyVisitor.result();
    }

    public static class ApplyExprTransformVisitor
    implements ExprVisitor {
        private ExprTransform transform;
        private final Stack<Expr> stack = new Stack();

        final Expr result() {
            if (this.stack.size() != 1) {
                ALog.warn(this, "Stack is not aligned");
            }
            return this.stack.pop();
        }

        ApplyExprTransformVisitor(ExprTransform transform) {
            this.transform = transform;
        }

        public void startVisit() {
        }

        public void finishVisit() {
        }

        public void visit(ExprFunction func) {
        }

        public void visit(ExprFunctionOp funcOp) {
        }

        public void visit(NodeValue nv) {
        }

        public void visit(ExprVar var) {
        }
    }
}

