/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.sparql.engine.Renamer;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.FunctionEnv;

public class E_Conditional
extends ExprFunction {
    private static final String printName = "if";
    private Expr condition;
    private Expr thenExpr;
    private Expr elseExpr;

    public E_Conditional(Expr condition, Expr thenExpr, Expr elseExpr) {
        super(printName);
        this.condition = condition;
        this.thenExpr = thenExpr;
        this.elseExpr = elseExpr;
    }

    public Expr getArg(int i) {
        if (--i == 0) {
            return this.condition;
        }
        if (i == 1) {
            return this.thenExpr;
        }
        if (i == 2) {
            return this.elseExpr;
        }
        return null;
    }

    public int numArgs() {
        return 3;
    }

    public Expr copySubstitute(Binding binding, boolean foldConstants, Renamer renamer) {
        Expr e1 = this.condition.copySubstitute(binding, foldConstants, renamer);
        Expr e2 = this.thenExpr.copySubstitute(binding, foldConstants, renamer);
        Expr e3 = this.elseExpr.copySubstitute(binding, foldConstants, renamer);
        return new E_Conditional(e1, e2, e3);
    }

    public NodeValue eval(Binding binding, FunctionEnv env) {
        NodeValue nv = this.condition.eval(binding, env);
        if (this.condition.isSatisfied(binding, env)) {
            return this.thenExpr.eval(binding, env);
        }
        return this.elseExpr.eval(binding, env);
    }
}

