/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQNotImplemented;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprFunction1;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.util.LabelToNodeMap;
import com.hp.hpl.jena.sparql.util.Symbol;
import java.util.IdentityHashMap;

public class E_BNode
extends ExprFunction1 {
    private static final String symbol = "bnode";
    private static final Symbol keyMap = Symbol.create("arq:internal:bNodeMappings");

    public E_BNode() {
        super((Expr)null, symbol);
    }

    public E_BNode(Expr expr) {
        super(expr, symbol);
    }

    public NodeValue eval(NodeValue v) {
        throw new ARQNotImplemented();
    }

    public NodeValue evalSpecial(Binding binding, FunctionEnv env) {
        LabelToNodeMap mapper;
        if (this.expr == null) {
            return NodeValue.makeNode(Node.createAnon());
        }
        NodeValue x = this.expr.eval(binding, env);
        if (!x.isString()) {
            throw new ExprEvalException("Not a string: " + x);
        }
        Integer key = System.identityHashCode(binding);
        IdentityHashMap<Binding, LabelToNodeMap> mapping = (IdentityHashMap<Binding, LabelToNodeMap>)env.getContext().get(keyMap);
        if (mapping == null) {
            mapping = new IdentityHashMap<Binding, LabelToNodeMap>();
            env.getContext().set(keyMap, mapping);
        }
        if ((mapper = (LabelToNodeMap)mapping.get(binding)) == null) {
            mapper = LabelToNodeMap.createBNodeMap();
            mapping.put(binding, mapper);
        }
        Node bnode2 = mapper.asNode(x.getString());
        return NodeValue.makeNode(bnode2);
    }

    public Expr copy(Expr expr) {
        return new E_BNode(expr);
    }
}

