/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.ARQNotImplemented;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.Transformer;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpGroup;
import com.hp.hpl.jena.sparql.algebra.op.OpPath;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpTriple;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.engine.Renamer;
import com.hp.hpl.jena.sparql.engine.RenamerVars;
import com.hp.hpl.jena.sparql.expr.E_Aggregator;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarRename {
    public static Op rename(Op op, Collection<Var> constants) {
        RenamerVars renamer = new RenamerVars(constants);
        TransformRename transform = new TransformRename(renamer);
        return Transformer.transform(transform, op);
    }

    public static ExprList rename(ExprList exprList, Set<Var> constants) {
        ExprList exprList2 = new ExprList();
        boolean changed = false;
        for (Expr expr : exprList) {
            Expr expr2;
            if (expr != (expr2 = VarRename.rename(expr, constants))) {
                changed = true;
            }
            exprList2.add(expr2);
        }
        if (!changed) {
            return exprList;
        }
        return exprList2;
    }

    public static Expr rename(Expr expr, Set<Var> constants) {
        return null;
    }

    static class TransformRename
    extends TransformCopy {
        private final Renamer renamer;

        public TransformRename(Renamer renamer) {
            this.renamer = renamer;
        }

        public Op transform(OpTriple opTriple) {
            Triple t2 = this.rename(opTriple.getTriple());
            if (t2 == opTriple.getTriple()) {
                return super.transform(opTriple);
            }
            return new OpTriple(t2);
        }

        public Op transform(OpFilter opFilter, Op subOp) {
            ExprList exprList = opFilter.getExprs();
            ExprList exprList2 = this.rename(exprList);
            return OpFilter.filter(exprList2, subOp);
        }

        public Op transform(OpBGP opBGP) {
            BasicPattern bgp2 = this.rename(opBGP.getPattern());
            if (bgp2 == opBGP.getPattern()) {
                return super.transform(opBGP);
            }
            return new OpBGP(bgp2);
        }

        public Op transform(OpPath opPath) {
            return null;
        }

        public Op transform(OpQuadPattern opQuadPattern) {
            BasicPattern bgp2 = this.rename(opQuadPattern.getBasicPattern());
            Node g2 = opQuadPattern.getGraphNode();
            if (g2 == opQuadPattern.getGraphNode() && bgp2 == opQuadPattern.getBasicPattern()) {
                return super.transform(opQuadPattern);
            }
            return new OpQuadPattern(g2, bgp2);
        }

        public Op transform(OpGraph opGraph, Op subOp) {
            Node g2 = this.renamer.rename(opGraph.getNode());
            if (g2 == opGraph.getNode()) {
                return super.transform(opGraph, subOp);
            }
            return new OpGraph(g2, subOp);
        }

        public Op transform(OpDatasetNames opDatasetNames) {
            Node g2 = this.renamer.rename(opDatasetNames.getGraphNode());
            if (g2 == opDatasetNames.getGraphNode()) {
                return super.transform(opDatasetNames);
            }
            return new OpDatasetNames(g2);
        }

        public Op transform(OpTable opTable) {
            if (opTable.isJoinIdentity()) {
                return opTable;
            }
            throw new ARQNotImplemented();
        }

        public Op transform(OpProject opProject, Op subOp) {
            throw new ARQNotImplemented();
        }

        public Op transform(OpAssign opAssign, Op subOp) {
            VarExprList varExprList = opAssign.getVarExprList();
            VarExprList varExprList2 = this.rename(varExprList);
            return OpAssign.assign(subOp, varExprList2);
        }

        public Op transform(OpGroup opGroup, Op subOp) {
            VarExprList groupVars = this.rename(opGroup.getGroupVars());
            ArrayList<E_Aggregator> aggregators = new ArrayList<E_Aggregator>();
            for (E_Aggregator agg : opGroup.getAggregators()) {
                aggregators.add(agg.copySubstitute(null, false, this.renamer));
            }
            return new OpGroup(subOp, groupVars, aggregators);
        }

        private BasicPattern rename(BasicPattern pattern) {
            BasicPattern bgp2 = new BasicPattern();
            boolean changed = false;
            for (Triple triple : pattern) {
                Triple t2 = this.rename(triple);
                bgp2.add(t2);
                if (t2 == triple) continue;
                changed = true;
            }
            if (!changed) {
                return pattern;
            }
            return bgp2;
        }

        private QuadPattern rename(QuadPattern pattern) {
            QuadPattern qp2 = new QuadPattern();
            boolean changed = false;
            for (Quad quad : pattern) {
                Quad q2 = this.rename(quad);
                qp2.add(q2);
                if (q2 == quad) continue;
                changed = true;
            }
            if (!changed) {
                return pattern;
            }
            return qp2;
        }

        private Triple rename(Triple triple) {
            Node o1;
            Node p1;
            boolean change = false;
            Node s = triple.getSubject();
            Node p = triple.getPredicate();
            Node o = triple.getObject();
            Node s1 = this.renamer.rename(s);
            if (s1 != s) {
                change = true;
                s = s1;
            }
            if ((p1 = this.renamer.rename(p)) != p) {
                change = true;
                p = p1;
            }
            if ((o1 = this.renamer.rename(o)) != o) {
                change = true;
                o = o1;
            }
            if (!change) {
                return triple;
            }
            return new Triple(s, p, o);
        }

        private Quad rename(Quad quad) {
            Node o1;
            Node p1;
            Node s1;
            boolean change = false;
            Node s = quad.getSubject();
            Node p = quad.getPredicate();
            Node o = quad.getObject();
            Node g = quad.getGraph();
            Node g1 = this.renamer.rename(g);
            if (g1 != g) {
                change = true;
                g = g1;
            }
            if ((s1 = this.renamer.rename(s)) != s) {
                change = true;
                s = s1;
            }
            if ((p1 = this.renamer.rename(p)) != p) {
                change = true;
                p = p1;
            }
            if ((o1 = this.renamer.rename(o)) != o) {
                change = true;
                o = o1;
            }
            if (!change) {
                return quad;
            }
            return new Quad(g, s, p, o);
        }

        private VarExprList rename(VarExprList varExprList) {
            VarExprList varExprList2 = new VarExprList();
            for (Var v : varExprList.getVars()) {
                Expr expr = varExprList.getExpr(v);
                Var v2 = (Var)this.renamer.rename((Node)v);
                Expr expr2 = expr != null ? this.rename(expr) : null;
                varExprList2.add(v2, expr2);
            }
            return varExprList2;
        }

        private ExprList rename(ExprList exprList) {
            ExprList exprList2 = new ExprList();
            boolean changed = false;
            for (Expr expr : exprList) {
                Expr expr2;
                if (expr != (expr2 = this.rename(expr))) {
                    changed = true;
                }
                exprList2.add(expr2);
            }
            if (!changed) {
                return exprList;
            }
            return exprList2;
        }

        private Expr rename(Expr expr) {
            return expr.copySubstitute(null, false, this.renamer);
        }
    }
}

