/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitorBase;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarFinder {
    VarUsageVisitor varUsageVisitor;

    public static Set<Var> optDefined(Op op) {
        return VarUsageVisitor.apply((Op)op).optDefines;
    }

    public static Set<Var> fixed(Op op) {
        return VarUsageVisitor.apply((Op)op).defines;
    }

    public static Set<Var> filter(Op op) {
        return VarUsageVisitor.apply((Op)op).filterMentions;
    }

    private static void vars(Set<Var> vars, Triple triple) {
        VarFinder.slot(vars, triple.getSubject());
        VarFinder.slot(vars, triple.getPredicate());
        VarFinder.slot(vars, triple.getObject());
    }

    private static void vars(Set<Var> acc, BasicPattern pattern) {
        for (Triple triple : pattern) {
            VarFinder.vars(acc, triple);
        }
    }

    private static void slot(Set<Var> vars, Node node) {
        if (Var.isVar(node)) {
            vars.add(Var.alloc(node));
        }
    }

    public VarFinder(Op op) {
        this.varUsageVisitor = VarUsageVisitor.apply(op);
    }

    public Set<Var> getOpt() {
        return this.varUsageVisitor.optDefines;
    }

    public Set<Var> getFilter() {
        return this.varUsageVisitor.filterMentions;
    }

    public Set<Var> getFixed() {
        return this.varUsageVisitor.defines;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VarUsageVisitor
    extends OpVisitorBase {
        Set<Var> defines = null;
        Set<Var> optDefines = null;
        Set<Var> filterMentions = null;

        static VarUsageVisitor apply(Op op) {
            VarUsageVisitor v = new VarUsageVisitor();
            op.visit(v);
            return v;
        }

        VarUsageVisitor() {
            this.defines = new HashSet<Var>();
            this.optDefines = new HashSet<Var>();
            this.filterMentions = new HashSet<Var>();
        }

        VarUsageVisitor(Set<Var> _defines, Set<Var> _optDefines, Set<Var> _filterMentions) {
            this.defines = _defines;
            this.optDefines = _optDefines;
            this.filterMentions = _filterMentions;
        }

        @Override
        public void visit(OpQuadPattern quadPattern) {
            VarFinder.slot(this.defines, quadPattern.getGraphNode());
            BasicPattern triples = quadPattern.getBasicPattern();
            VarFinder.vars((Set<Var>)this.defines, triples);
        }

        @Override
        public void visit(OpBGP opBGP) {
            BasicPattern triples = opBGP.getPattern();
            VarFinder.vars((Set<Var>)this.defines, triples);
        }

        @Override
        public void visit(OpExt opExt) {
            opExt.effectiveOp().visit(this);
        }

        @Override
        public void visit(OpJoin opJoin) {
            VarUsageVisitor leftUsage = VarUsageVisitor.apply(opJoin.getLeft());
            VarUsageVisitor rightUsage = VarUsageVisitor.apply(opJoin.getRight());
            this.defines.addAll(leftUsage.defines);
            this.optDefines.addAll(leftUsage.optDefines);
            this.filterMentions.addAll(leftUsage.filterMentions);
            this.defines.addAll(rightUsage.defines);
            this.optDefines.addAll(rightUsage.optDefines);
            this.filterMentions.addAll(rightUsage.filterMentions);
        }

        @Override
        public void visit(OpLeftJoin opLeftJoin) {
            VarUsageVisitor leftUsage = VarUsageVisitor.apply(opLeftJoin.getLeft());
            VarUsageVisitor rightUsage = VarUsageVisitor.apply(opLeftJoin.getRight());
            this.defines.addAll(leftUsage.defines);
            this.optDefines.addAll(leftUsage.optDefines);
            this.filterMentions.addAll(leftUsage.filterMentions);
            this.optDefines.addAll(rightUsage.defines);
            this.optDefines.addAll(rightUsage.optDefines);
            this.filterMentions.addAll(rightUsage.filterMentions);
            this.optDefines.removeAll(leftUsage.defines);
            if (opLeftJoin.getExprs() != null) {
                opLeftJoin.getExprs().varsMentioned(this.filterMentions);
            }
        }

        @Override
        public void visit(OpUnion opUnion) {
            VarUsageVisitor leftUsage = VarUsageVisitor.apply(opUnion.getLeft());
            VarUsageVisitor rightUsage = VarUsageVisitor.apply(opUnion.getRight());
            this.defines.addAll(leftUsage.defines);
            this.optDefines.addAll(leftUsage.optDefines);
            this.filterMentions.addAll(leftUsage.filterMentions);
            this.defines.addAll(rightUsage.defines);
            this.optDefines.addAll(rightUsage.optDefines);
            this.filterMentions.addAll(rightUsage.filterMentions);
        }

        @Override
        public void visit(OpGraph opGraph) {
            VarFinder.slot(this.defines, opGraph.getNode());
            opGraph.getSubOp().visit(this);
        }

        @Override
        public void visit(OpFilter opFilter) {
            opFilter.getExprs().varsMentioned(this.filterMentions);
            opFilter.getSubOp().visit(this);
        }

        @Override
        public void visit(OpAssign opAssign) {
            opAssign.getSubOp().visit(this);
            List<Var> vars = opAssign.getVarExprList().getVars();
            this.defines.addAll(vars);
        }

        @Override
        public void visit(OpProject opProject) {
            List<Var> vars = opProject.getVars();
            VarUsageVisitor subUsage = VarUsageVisitor.apply(opProject.getSubOp());
            subUsage.defines.retainAll(vars);
            subUsage.optDefines.retainAll(vars);
            subUsage.optDefines.retainAll(vars);
            this.defines.addAll(subUsage.defines);
            this.optDefines.addAll(subUsage.optDefines);
            this.filterMentions.addAll(subUsage.filterMentions);
        }

        @Override
        public void visit(OpTable opTable) {
        }

        @Override
        public void visit(OpNull opNull) {
        }
    }
}

