/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.opt;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.OpDisjunction;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.opt.TransformFilterEquality;
import com.hp.hpl.jena.sparql.expr.E_LogicalOr;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformFilterDisjunction
extends TransformCopy {
    @Override
    public Op transform(OpFilter opFilter, Op subOp) {
        ExprList exprList = opFilter.getExprs();
        boolean processDisjunction = false;
        for (Expr expr : exprList) {
            if (!this.isDisjunction(expr)) continue;
            processDisjunction = true;
            break;
        }
        if (!processDisjunction) {
            return super.transform(opFilter, subOp);
        }
        ExprList exprList2 = new ExprList();
        Op newOp = subOp;
        HashSet doneSoFar = new HashSet();
        for (Expr expr : exprList) {
            if (!this.isDisjunction(expr)) {
                exprList2.add(expr);
                continue;
            }
            Op op2 = TransformFilterDisjunction.expandDisjunction(expr, newOp);
            if (op2 == null) continue;
            newOp = op2;
        }
        if (exprList2.isEmpty()) {
            return newOp;
        }
        return super.transform(opFilter, subOp);
    }

    private boolean isDisjunction(Expr expr) {
        return expr instanceof E_LogicalOr;
    }

    public static Op expandDisjunction(Expr expr, Op subOp) {
        List<Expr> exprList = TransformFilterDisjunction.explodeDisjunction(new ArrayList<Expr>(), expr);
        ArrayList<Expr> exprList2 = null;
        Op op = null;
        for (Expr e2 : exprList) {
            Op op2 = TransformFilterEquality.processFilter(e2, subOp);
            if (op2 == null) {
                if (exprList2 == null) {
                    exprList2 = new ArrayList<Expr>();
                }
                exprList2.add(e2);
            }
            op = OpDisjunction.create(op, op2);
        }
        if (exprList2 != null && !exprList2.isEmpty()) {
            Expr eOther = null;
            for (Expr e3 : exprList2) {
                if (eOther == null) {
                    eOther = e3;
                    continue;
                }
                eOther = new E_LogicalOr(eOther, e3);
            }
            Op opOther = OpFilter.filter(eOther, subOp);
            op = OpDisjunction.create(op, opOther);
        }
        return op;
    }

    private static List<Expr> explodeDisjunction(List<Expr> exprList, Expr expr) {
        if (!(expr instanceof E_LogicalOr)) {
            exprList.add(expr);
            return exprList;
        }
        E_LogicalOr exprOr = (E_LogicalOr)expr;
        Expr e1 = exprOr.getArg1();
        Expr e2 = exprOr.getArg2();
        TransformFilterDisjunction.explodeDisjunction(exprList, e1);
        TransformFilterDisjunction.explodeDisjunction(exprList, e2);
        return exprList;
    }
}

