/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.OpVisitorByType;
import com.hp.hpl.jena.sparql.algebra.OpWalker;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.TransformWrapper;
import com.hp.hpl.jena.sparql.algebra.op.Op0;
import com.hp.hpl.jena.sparql.algebra.op.Op1;
import com.hp.hpl.jena.sparql.algebra.op.Op2;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpN;
import com.hp.hpl.jena.sparql.algebra.op.OpService;
import com.hp.hpl.jena.sparql.util.ALog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;

public class Transformer {
    private static Transformer singleton = new Transformer();
    protected static boolean noDupIfSame = true;

    public static Transformer get() {
        return singleton;
    }

    public static void set(Transformer value) {
        singleton = value;
    }

    public static Op transform(Transform transform, Op op) {
        return Transformer.get().transformation(transform, op, null, null);
    }

    public static Op transform(Transform transform, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        return Transformer.get().transformation(transform, op, beforeVisitor, afterVisitor);
    }

    public static Op transformSkipService(Transform transform, Op op) {
        return Transformer.transformSkipService(transform, op, null, null);
    }

    public static Op transformSkipService(Transform transform, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        transform = new TransformSkipService(transform);
        return Transformer.transform(transform, op, beforeVisitor, afterVisitor);
    }

    protected Op transformation(Transform transform, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        ApplyTransformVisitor v = new ApplyTransformVisitor(transform);
        return this.transformation(v, op, beforeVisitor, afterVisitor);
    }

    protected Op transformation(ApplyTransformVisitor transformApply, Op op, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        if (op == null) {
            ALog.warn(this, "Attempt to transform a null Op - ignored");
            return op;
        }
        OpWalker.walk(op, transformApply, beforeVisitor, afterVisitor);
        Op r = transformApply.result();
        return r;
    }

    protected Transformer() {
    }

    static class TransformSkipService
    extends TransformWrapper {
        public TransformSkipService(Transform transform) {
            super(transform);
        }

        public Op transform(OpService opService, Op subOp) {
            return opService;
        }
    }

    static class WalkerVisitorSkipService
    extends OpWalker.WalkerVisitor {
        public WalkerVisitorSkipService(OpVisitor visitor, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
            super(visitor, beforeVisitor, afterVisitor);
        }

        public WalkerVisitorSkipService(OpVisitor visitor) {
            super(visitor);
        }

        public void visit(OpService op) {
            this.before(op);
            if (this.visitor != null) {
                op.visit(this.visitor);
            }
            this.after(op);
        }
    }

    static class ApplyTransformVisitorServiceAsLeaf
    extends ApplyTransformVisitor {
        public ApplyTransformVisitorServiceAsLeaf(Transform transform) {
            super(transform);
        }

        public void visit(OpService op) {
            this.push(op);
        }
    }

    public static class ApplyTransformVisitor
    extends OpVisitorByType {
        protected final Transform transform;
        private final Stack<Op> stack = new Stack();

        protected final Op pop() {
            return this.stack.pop();
        }

        protected final void push(Op op) {
            this.stack.push(op);
        }

        public ApplyTransformVisitor(Transform transform) {
            this.transform = transform;
        }

        public final Op result() {
            if (this.stack.size() != 1) {
                ALog.warn(this, "Stack is not aligned");
            }
            return this.pop();
        }

        protected void visit0(Op0 op) {
            this.push(op.apply(this.transform));
        }

        protected void visit1(Op1 op) {
            Op subOp = null;
            if (op.getSubOp() != null) {
                subOp = this.pop();
            }
            this.push(op.apply(this.transform, subOp));
        }

        protected void visit2(Op2 op) {
            Op left = null;
            Op right = null;
            if (op.getRight() != null) {
                right = this.pop();
            }
            if (op.getLeft() != null) {
                left = this.pop();
            }
            Op opX = op.apply(this.transform, left, right);
            this.push(opX);
        }

        protected void visitN(OpN op) {
            ArrayList<Op> x = new ArrayList<Op>(op.size());
            Iterator<Op> iter = op.iterator();
            while (iter.hasNext()) {
                Op sub = iter.next();
                Op r = this.pop();
                if (r == null) continue;
                x.add(0, r);
            }
            Op opX = op.apply(this.transform, x);
            this.push(opX);
        }

        protected void visitExt(OpExt op) {
            this.push(this.transform.transform(op));
        }
    }
}

