/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.ArgModuleGeneral;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import com.hp.hpl.jena.iri.IRI;
import org.openjena.riot.IRIResolver;

public class ModLangParse
implements ArgModuleGeneral {
    private ArgDecl argCheck = new ArgDecl(true, "check");
    private ArgDecl argNoCheck = new ArgDecl(false, "nocheck");
    private ArgDecl argSink = new ArgDecl(false, "sink", "null");
    private ArgDecl argSkip = new ArgDecl(false, "skip");
    private ArgDecl argNoSkip = new ArgDecl(false, "noSkip");
    private ArgDecl argStop = new ArgDecl(false, "stopOnError", "stoponerror", "stop");
    private ArgDecl argBase = new ArgDecl(true, "base");
    private String baseIRI = null;
    private boolean explicitCheck = false;
    private boolean explicitNoCheck = false;
    private boolean skipOnBadTerm = false;
    private boolean stopOnBadTerm = false;
    private boolean bitbucket = false;

    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("Parser control");
        cmdLine.add(this.argSink, "--sink", "Parse but throw away output");
        cmdLine.add(this.argBase, "--base=URI", "Set the base URI (does not apply to N-triples and N-Quads)");
        cmdLine.add(this.argCheck, "--check=boolean", "Addition checking of RDF terms (default: off for N-triples, N-Quads, on for Turtle and TriG)");
    }

    public void processArgs(CmdArgModule cmdLine) {
        if (cmdLine.contains(this.argNoCheck)) {
            this.explicitNoCheck = false;
        }
        if (cmdLine.contains(this.argCheck)) {
            boolean b;
            this.explicitCheck = b = !cmdLine.getArg(this.argCheck).getValue().equalsIgnoreCase("false");
            boolean bl = this.explicitNoCheck = !b;
        }
        if (cmdLine.contains(this.argSkip)) {
            this.skipOnBadTerm = true;
        }
        if (cmdLine.contains(this.argNoSkip)) {
            this.skipOnBadTerm = false;
        }
        if (cmdLine.contains(this.argBase)) {
            this.baseIRI = cmdLine.getValue(this.argBase);
            IRI iri = IRIResolver.resolveGlobal(this.baseIRI);
            if (iri.hasViolation(false)) {
                throw new CmdException("Bad base IRI: " + this.baseIRI);
            }
            if (!iri.isAbsolute()) {
                throw new CmdException("Base IRI must be an absolute IRI: " + this.baseIRI);
            }
        }
        this.stopOnBadTerm = cmdLine.contains(this.argStop);
        this.bitbucket = cmdLine.contains(this.argSink);
    }

    public boolean explicitChecking() {
        return this.explicitCheck;
    }

    public boolean explicitNoChecking() {
        return this.explicitNoCheck;
    }

    public boolean skipOnBadTerm() {
        return this.skipOnBadTerm;
    }

    public boolean stopOnBadTerm() {
        return this.stopOnBadTerm;
    }

    public boolean toBitBucket() {
        return this.bitbucket;
    }

    public String getBaseIRI() {
        return this.baseIRI;
    }
}

