/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.mgt;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.SystemARQ;
import com.hp.hpl.jena.sparql.engine.QueryEngineBase;
import com.hp.hpl.jena.sparql.mgt.ContextMBean;
import com.hp.hpl.jena.sparql.mgt.QueryEngineInfo;
import com.hp.hpl.jena.sparql.util.ALog;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ARQMgt {
    private static Logger log = LoggerFactory.getLogger(ARQMgt.class);
    private static boolean initialized = false;
    private static boolean noJMX = false;
    private static Map<ObjectName, Object> mgtObjects = new HashMap<ObjectName, Object>();
    private static MBeanServer mbs = null;

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            mbs = ManagementFactory.getPlatformMBeanServer();
            String NS = "com.hp.hpl.jena.sparql";
            ContextMBean cxtBean = new ContextMBean(ARQ.getContext());
            QueryEngineInfo qeInfo = QueryEngineBase.queryEngineInfo;
            ARQMgt.register(NS + ".system:type=SystemInfo", SystemARQ.sysInfo);
            ARQMgt.register(NS + ".system:type=Context", cxtBean);
            ARQMgt.register(NS + ".system:type=Engine", qeInfo);
        }
        catch (Throwable ex) {
            ALog.warn(ARQMgt.class, "Failed to initialize JMX", ex);
            noJMX = true;
            mbs = null;
        }
    }

    public static void register(String name, Object bean) {
        ARQMgt.init();
        if (noJMX) {
            return;
        }
        ObjectName objName = null;
        try {
            objName = new ObjectName(name);
        }
        catch (MalformedObjectNameException ex) {
            throw new ARQException("Failed to create name '" + name + "': " + ex.getMessage(), ex);
        }
        try {
            if (mbs.isRegistered(objName)) {
                try {
                    mbs.unregisterMBean(objName);
                }
                catch (InstanceNotFoundException ex) {
                    // empty catch block
                }
            }
            log.debug("Register MBean: " + objName);
            mbs.registerMBean(bean, objName);
            mgtObjects.put(objName, bean);
        }
        catch (NotCompliantMBeanException ex) {
            log.warn("Failed to register '" + objName.getCanonicalName() + "': " + ex.getMessage());
            throw new ARQException("Failed to register '" + objName.getCanonicalName() + "': " + ex.getMessage(), ex);
        }
        catch (InstanceAlreadyExistsException ex) {
            log.warn("Failed to register '" + objName.getCanonicalName() + "': " + ex.getMessage());
            throw new ARQException("Failed to register '" + objName.getCanonicalName() + "': " + ex.getMessage(), ex);
        }
        catch (MBeanRegistrationException ex) {
            log.warn("Failed to register '" + objName.getCanonicalName() + "': " + ex.getMessage());
            throw new ARQException("Failed to register '" + objName.getCanonicalName() + "': " + ex.getMessage(), ex);
        }
    }
}

